/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics.util;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.search.ReaderCache;
import com.atlassian.jira.issue.statistics.util.AbstractOneDimensionalHitCollector;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collection;
import java.util.Map;

@Internal
public class OneDimensionalTermHitCollector
extends AbstractOneDimensionalHitCollector {
    private final Map<String, Integer> result;

    public OneDimensionalTermHitCollector(String fieldId, Map<String, Integer> result, FieldVisibilityManager fieldVisibilityManager, ReaderCache readerCache, FieldManager fieldManager, ProjectManager projectManager) {
        super(fieldId, fieldVisibilityManager, readerCache, fieldManager, projectManager);
        this.result = result;
    }

    @Override
    protected void collectIrrelevant(int docId) {
    }

    @Override
    protected void collectWithTerms(int docId, Collection<String> terms) {
        if (terms == null) {
            this.incrementCount(null, this.result);
        } else {
            for (String term : terms) {
                this.incrementCount(term, this.result);
            }
        }
    }

    private void incrementCount(String key, Map<String, Integer> map) {
        Integer count = map.get(key);
        if (count == null) {
            count = 1;
        } else {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
        map.put(key, count);
    }
}

