/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.query.order;

import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.order.SortOrder;
import java.io.Serializable;

public class SearchSort
implements Serializable {
    private final SortOrder order;
    private final String field;

    public SearchSort(String field) {
        this(field, (SortOrder)null);
    }

    public SearchSort(String field, SortOrder order) {
        this.field = Assertions.notBlank("field", field);
        this.order = order;
    }

    public SearchSort(String order, String field) {
        this(field, SortOrder.parseString(order));
    }

    public SearchSort(SearchSort copy) {
        Assertions.notNull("copy", copy);
        this.field = copy.field;
        this.order = copy.order;
    }

    public String getOrder() {
        return this.order == null ? null : this.order.name();
    }

    public SortOrder getSortOrder() {
        return this.order;
    }

    public String getField() {
        return this.field;
    }

    public boolean isReverse() {
        return this.order == SortOrder.DESC;
    }

    public String toString() {
        if (this.order != null) {
            return this.field + " " + (Object)((Object)this.order);
        }
        return this.field;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchSort that = (SearchSort)o;
        if (!this.field.equals(that.field)) {
            return false;
        }
        return this.order == that.order;
    }

    public int hashCode() {
        int result = this.order != null ? this.order.hashCode() : 0;
        result = 31 * result + this.field.hashCode();
        return result;
    }
}

