/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.lucene.parsing.LuceneQueryParserFactory;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;

public class FreeTextFieldValidator
implements ClauseValidator {
    public static final List<String> INVALID_FIRST_CHAR_LIST = ImmutableList.of((Object)"?", (Object)"*", (Object)"~", (Object)":", (Object)";", (Object)"!", (Object)"]", (Object)"[", (Object)"^", (Object)"{", (Object)"}", (Object)"(", (Object[])new String[]{")"});
    private static final Logger log = Logger.getLogger(FreeTextFieldValidator.class);
    private final String indexField;
    private final JqlOperandResolver operandResolver;

    public FreeTextFieldValidator(String indexField, JqlOperandResolver operandResolver) {
        this.indexField = Assertions.notBlank("indexField", indexField);
        this.operandResolver = Assertions.notNull("operandResolver", operandResolver);
    }

    @Override
    public MessageSet validate(User searcher, TerminalClause terminalClause) {
        MessageSetImpl messageSet = new MessageSetImpl();
        I18nHelper i18n = this.getI18n(searcher);
        Operator operator = terminalClause.getOperator();
        String fieldName = terminalClause.getName();
        if (!this.handlesOperator(operator)) {
            messageSet.addErrorMessage(i18n.getText("jira.jql.clause.does.not.support.operator", operator.getDisplayString(), fieldName));
            return messageSet;
        }
        Operand operand = terminalClause.getOperand();
        List<QueryLiteral> values = this.operandResolver.getValues(searcher, operand, terminalClause);
        if (values != null) {
            for (QueryLiteral literal : values) {
                if (literal.isEmpty()) continue;
                String query = literal.asString();
                if (StringUtils.isNotBlank((String)query)) {
                    String firstLetter = String.valueOf(query.charAt(0));
                    if (INVALID_FIRST_CHAR_LIST.contains(firstLetter)) {
                        if (this.operandResolver.isFunctionOperand(literal.getSourceOperand())) {
                            messageSet.addErrorMessage(i18n.getText("jira.jql.text.clause.bad.start.function", literal.getSourceOperand().getName(), terminalClause.getName(), firstLetter));
                            continue;
                        }
                        messageSet.addErrorMessage(i18n.getText("jira.jql.text.clause.bad.start", query, terminalClause.getName(), firstLetter));
                        continue;
                    }
                    messageSet.addMessageSet(this.parseQuery(this.indexField, fieldName, query, i18n, literal.getSourceOperand()));
                    continue;
                }
                messageSet.addErrorMessage(i18n.getText("jira.jql.text.clause.does.not.support.empty", fieldName));
            }
        } else {
            log.error((Object)("Text field validation was provided an operand handler that gave us back more than one value when validating '" + fieldName + "'."));
        }
        return messageSet;
    }

    private MessageSet parseQuery(String indexField, String fieldName, String value, I18nHelper i18n, Operand operand) {
        MessageSetImpl messageSet = new MessageSetImpl();
        try {
            this.getQueryParser(indexField).parse(value);
        }
        catch (ParseException e) {
            this.handleException(fieldName, value, i18n, operand, messageSet, (Exception)((Object)e));
        }
        catch (RuntimeException e) {
            this.handleException(fieldName, value, i18n, operand, messageSet, e);
        }
        return messageSet;
    }

    private void handleException(String fieldName, String value, I18nHelper i18n, Operand operand, MessageSetImpl messageSet, Exception ex) {
        log.debug((Object)String.format("Unable to parse the text '%s' for field '%s'.", value, fieldName), (Throwable)ex);
        if (this.operandResolver.isFunctionOperand(operand)) {
            messageSet.addErrorMessage(i18n.getText("jira.jql.text.clause.does.not.parse.function", fieldName, operand.getName()));
        } else {
            messageSet.addErrorMessage(i18n.getText("jira.jql.text.clause.does.not.parse", value, fieldName));
        }
    }

    private boolean handlesOperator(Operator operator) {
        return OperatorClasses.TEXT_OPERATORS.contains((Object)operator);
    }

    I18nHelper getI18n(User user) {
        I18nHelper.BeanFactory beanFactory = ComponentAccessor.getComponent(I18nHelper.BeanFactory.class);
        return beanFactory.getInstance(user);
    }

    QueryParser getQueryParser(String indexField) {
        return ComponentAccessor.getComponent(LuceneQueryParserFactory.class).createParserFor(indexField);
    }
}

