/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.util;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.util.PathUtils;
import java.io.File;

@PublicApi
public interface IndexPathManager {
    public static final String INDEXES_DIR = PathUtils.joinPaths("caches", "indexes");

    public String getIndexRootPath();

    public String getDefaultIndexRootPath();

    public String getIssueIndexPath();

    public String getCommentIndexPath();

    public String getChangeHistoryIndexPath();

    public String getPluginIndexRootPath();

    public String getSharedEntityIndexPath();

    public void setIndexRootPath(String var1);

    public void setUseDefaultDirectory();

    public boolean getUseDefaultDirectory();

    public Mode getMode();

    public static class PropertiesAdaptor
    implements IndexPathManager {
        private final ApplicationProperties applicationProperties;
        private final JiraHome jiraHome;

        public PropertiesAdaptor(ApplicationProperties applicationProperties, JiraHome jiraHome) {
            this.applicationProperties = applicationProperties;
            this.jiraHome = jiraHome;
        }

        @Override
        public String getIndexRootPath() {
            if (this.applicationProperties.getOption("jira.path.index.use.default.directory")) {
                return this.getDefaultIndexRootPath();
            }
            return this.applicationProperties.getString("jira.path.index");
        }

        @Override
        public String getDefaultIndexRootPath() {
            return new File(this.jiraHome.getLocalHomePath(), INDEXES_DIR).getAbsolutePath();
        }

        @Override
        public void setIndexRootPath(String rootPath) {
            this.applicationProperties.setString("jira.path.index", rootPath);
            this.applicationProperties.setOption("jira.path.index.use.default.directory", Boolean.FALSE);
        }

        @Override
        public void setUseDefaultDirectory() {
            this.applicationProperties.setOption("jira.path.index.use.default.directory", Boolean.TRUE);
        }

        @Override
        public boolean getUseDefaultDirectory() {
            return this.applicationProperties.getOption("jira.path.index.use.default.directory");
        }

        @Override
        public Mode getMode() {
            if (!this.applicationProperties.getOption("jira.option.indexing")) {
                return Mode.DISABLED;
            }
            if (this.getUseDefaultDirectory()) {
                return Mode.DEFAULT;
            }
            return Mode.CUSTOM;
        }

        @Override
        public String getIssueIndexPath() {
            return PathUtils.appendFileSeparator(this.getIndexRootPath()) + "issues";
        }

        @Override
        public String getCommentIndexPath() {
            return PathUtils.appendFileSeparator(this.getIndexRootPath()) + "comments";
        }

        @Override
        public String getChangeHistoryIndexPath() {
            return PathUtils.appendFileSeparator(this.getIndexRootPath()) + "changes";
        }

        @Override
        public String getSharedEntityIndexPath() {
            return PathUtils.appendFileSeparator(this.getIndexRootPath()) + "entities";
        }

        @Override
        public String getPluginIndexRootPath() {
            return PathUtils.appendFileSeparator(this.getIndexRootPath()) + "plugins";
        }
    }

    public static enum Mode {
        DEFAULT,
        CUSTOM,
        DISABLED;

    }

    public static final class Directory {
        static final String ISSUES_SUBDIR = "issues";
        static final String COMMENTS_SUBDIR = "comments";
        static final String PLUGINS_SUBDIR = "plugins";
        static final String ENTITIES_SUBDIR = "entities";
        static final String CHANGE_HISTORY_SUBDIR = "changes";
    }
}

