/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.config.Feature;

@Internal
public enum CoreFeatures implements Feature
{
    ON_DEMAND,
    PREVENT_COMMENTS_LIMITING;

    private static final String FEATURE_KEY_PREFIX;
    private final String featureKey = CoreFeatures.class.getName() + '.' + this.name();
    private final boolean isUserSettable;

    private CoreFeatures() {
        this(false);
    }

    private CoreFeatures(boolean isUserSettable) {
        this.isUserSettable = isUserSettable;
    }

    @Override
    public String featureKey() {
        return this.featureKey;
    }

    public String systemPropertyKey() {
        return "atlassian.darkfeature." + this.featureKey;
    }

    public boolean isDevFeature() {
        return this.isUserSettable;
    }

    public boolean isSystemPropertyEnabled() {
        return Boolean.getBoolean(this.systemPropertyKey());
    }

    public static CoreFeatures forFeatureKey(String featureKey) {
        if (!featureKey.startsWith(FEATURE_KEY_PREFIX)) {
            return null;
        }
        try {
            return CoreFeatures.valueOf(featureKey.substring(FEATURE_KEY_PREFIX.length()));
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    static {
        FEATURE_KEY_PREFIX = CoreFeatures.class.getName() + '.';
    }
}

