/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.dataimport;

import java.io.File;
import org.apache.commons.lang.StringUtils;

public final class DataImportParams {
    private final String filename;
    private final String licenseString;
    private final boolean quickImport;
    private final boolean useDefaultPaths;
    private final boolean allowDowngrade;
    private final boolean isSetup;
    private final boolean outgoingMail;
    private final boolean changeOutgoingMailSettings;
    private final File unsafeJiraBackup;
    private final File unsafeAOBackup;
    private final boolean safeMode;
    private final boolean noLicenseCheck;

    private DataImportParams(String filename, String licenseString, boolean quickImport, boolean useDefaultPaths, boolean allowDowngrade, boolean isSetup, boolean outgoingMail, boolean changeOutgoingMailSettings, File unsafeJiraBackup, File unsafeAOBackup, boolean safeMode, boolean noLicenseCheck) {
        this.filename = filename;
        this.licenseString = licenseString;
        this.quickImport = quickImport;
        this.useDefaultPaths = useDefaultPaths;
        this.allowDowngrade = allowDowngrade;
        this.isSetup = isSetup;
        this.outgoingMail = outgoingMail;
        this.changeOutgoingMailSettings = changeOutgoingMailSettings;
        this.unsafeJiraBackup = unsafeJiraBackup;
        this.unsafeAOBackup = unsafeAOBackup;
        this.safeMode = safeMode;
        this.noLicenseCheck = noLicenseCheck;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getLicenseString() {
        return this.licenseString;
    }

    public boolean isQuickImport() {
        return this.quickImport;
    }

    public boolean isUseDefaultPaths() {
        return this.useDefaultPaths;
    }

    public boolean isAllowDowngrade() {
        return this.allowDowngrade;
    }

    public boolean isSetup() {
        return this.isSetup;
    }

    public File getUnsafeJiraBackup() {
        return this.unsafeJiraBackup;
    }

    public File getUnsafeAOBackup() {
        return this.unsafeAOBackup;
    }

    public boolean outgoingMail() {
        return this.outgoingMail;
    }

    public boolean shouldChangeOutgoingMail() {
        return this.changeOutgoingMailSettings;
    }

    public boolean isSafeMode() {
        return this.safeMode;
    }

    public boolean isNoLicenseCheck() {
        return this.noLicenseCheck;
    }

    public static class Builder {
        private final String filename;
        private String licenseString;
        private boolean quickImport = false;
        private boolean useDefaultPaths = true;
        private boolean allowDowngrade = false;
        private boolean isSetup = false;
        private boolean outgoingEmail;
        private File unsafeJiraBackup;
        private File unsafeAOBackup;
        private boolean changeOutgoingMail = false;
        private boolean safeMode = false;
        private boolean noLicenseCheck = false;

        public Builder(String filename) {
            this.filename = StringUtils.stripToNull((String)filename);
        }

        public Builder setupImport() {
            this.isSetup = true;
            return this;
        }

        public Builder setLicenseString(String licenseString) {
            this.licenseString = StringUtils.stripToNull((String)licenseString);
            return this;
        }

        public Builder setQuickImport(boolean quickImport) {
            this.quickImport = quickImport;
            return this;
        }

        public Builder setUseDefaultPaths(boolean useDefaultPaths) {
            this.useDefaultPaths = useDefaultPaths;
            return this;
        }

        public Builder setAllowDowngrade(boolean allowDowngrade) {
            this.allowDowngrade = allowDowngrade;
            return this;
        }

        public File getUnsafeJiraBackup() {
            return this.unsafeJiraBackup;
        }

        public Builder setUnsafeJiraBackup(File unsafeJiraBackup) {
            this.unsafeJiraBackup = unsafeJiraBackup;
            return this;
        }

        public File getUnsafeAOBackup() {
            return this.unsafeAOBackup;
        }

        public Builder setUnsafeAOBackup(File unsafeAOBackup) {
            this.unsafeAOBackup = unsafeAOBackup;
            return this;
        }

        public Builder setOutgoingEmailTo(boolean outgoingEmail) {
            this.outgoingEmail = outgoingEmail;
            this.changeOutgoingMail = true;
            return this;
        }

        public Builder setSafeMode() {
            this.safeMode = true;
            return this;
        }

        public Builder setNoLicenseCheck() {
            this.noLicenseCheck = true;
            return this;
        }

        public DataImportParams build() {
            return new DataImportParams(this.filename, this.licenseString, this.quickImport, this.useDefaultPaths, this.allowDowngrade, this.isSetup, this.outgoingEmail, this.changeOutgoingMail, this.unsafeJiraBackup, this.unsafeAOBackup, this.safeMode, this.noLicenseCheck);
        }
    }
}

