/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@Immutable
final class HelpPaths {
    @Nonnull
    private final ImmutableHelpPath defaultHelpPath;
    @Nonnull
    private final ImmutableMap<String, ImmutableHelpPath> helpPaths;

    HelpPaths(Properties extProperties, @Nullable Properties intProperties, boolean useOnDemandOverrides) {
        OverridableProperties externalProperties = new OverridableProperties(extProperties, useOnDemandOverrides);
        OverridableProperties internalProperties = new OverridableProperties(intProperties, useOnDemandOverrides);
        String urlPrefix = externalProperties.getProperty("url-prefix");
        String urlSuffix = externalProperties.getProperty("url-suffix");
        this.defaultHelpPath = HelpPaths.loadHelpPath("default", externalProperties, urlPrefix, urlSuffix, null);
        Map<String, ImmutableHelpPath> intPaths = this.getExternalPropertyPaths(externalProperties, this.defaultHelpPath, urlPrefix, urlSuffix);
        Map<String, ImmutableHelpPath> extPaths = this.getInternalPropertyPaths(internalProperties);
        this.helpPaths = ImmutableMap.builder().putAll(intPaths).putAll(extPaths).build();
    }

    ImmutableHelpPath get(String helpPathKey) {
        ImmutableHelpPath helpPath = (ImmutableHelpPath)this.helpPaths.get((Object)helpPathKey);
        if (helpPath != null) {
            return helpPath;
        }
        return this.defaultHelpPath;
    }

    ImmutableSet<String> keys() {
        return this.helpPaths.keySet();
    }

    private Map<String, ImmutableHelpPath> getExternalPropertyPaths(OverridableProperties externalProperties, ImmutableHelpPath defaultHelpPath, String urlPrefix, String urlSuffix) {
        HashMap newPaths = Maps.newHashMap();
        for (String property : externalProperties.propertyNames()) {
            int urlIndex = property.indexOf(".url");
            if (urlIndex == -1) continue;
            String propertyName = property.substring(0, urlIndex);
            ImmutableHelpPath helpPath = HelpPaths.loadHelpPath(propertyName, externalProperties, urlPrefix, urlSuffix, defaultHelpPath);
            newPaths.put(helpPath.key, helpPath);
        }
        return newPaths;
    }

    private Map<String, ImmutableHelpPath> getInternalPropertyPaths(OverridableProperties internalProperties) {
        if (internalProperties == null) {
            return Collections.emptyMap();
        }
        HashMap helpPaths = Maps.newHashMap();
        for (String keyStr : internalProperties.propertyNames()) {
            if (!keyStr.endsWith(".path")) continue;
            String key = keyStr.substring(0, keyStr.length() - 5);
            helpPaths.put(key, new ImmutableHelpPath().key(key).url(internalProperties.getProperty(keyStr)).title(internalProperties.getProperty(key + ".title")).local(Boolean.TRUE));
        }
        return helpPaths;
    }

    private static ImmutableHelpPath loadHelpPath(String name, OverridableProperties props, String prefix, String suffix, ImmutableHelpPath defaultHelpPath) {
        String title;
        String alt;
        ImmutableHelpPath helpPath = defaultHelpPath == null ? new ImmutableHelpPath() : defaultHelpPath;
        helpPath = helpPath.key(name);
        String url = props.getProperty(name + ".url");
        if (url != null) {
            String builtURL = HelpPaths.buildValidUrl(prefix, url, suffix);
            if (HelpPaths.isExternalLink(url)) {
                builtURL = HelpPaths.buildValidUrl("", url, "");
            }
            helpPath = helpPath.url(builtURL);
        }
        if ((alt = props.getProperty(name + ".alt")) != null) {
            helpPath = helpPath.alt(alt);
        }
        if ((title = props.getProperty(name + ".title")) != null) {
            helpPath = helpPath.title(title);
        }
        return helpPath;
    }

    private static String buildValidUrl(String prefix, String url, String suffix) {
        String targetUrl = url;
        String targetSuffix = suffix;
        int hashIndex = url.indexOf("#");
        if (hashIndex != -1 && (suffix.contains("?") || suffix.contains("&"))) {
            targetUrl = url.substring(0, hashIndex);
            targetSuffix = suffix + url.substring(hashIndex);
        }
        return prefix + targetUrl + targetSuffix;
    }

    private static boolean isExternalLink(String url) {
        String urlLowerCase = url.toLowerCase();
        return urlLowerCase.startsWith("http://") || urlLowerCase.startsWith("https://");
    }

    private static class OverridableProperties {
        private final Properties props;
        private final boolean useOnDemandOverride;

        OverridableProperties(Properties props, boolean useOnDemandOverride) {
            this.useOnDemandOverride = useOnDemandOverride;
            this.props = new Properties();
            if (props != null) {
                this.props.putAll((Map<?, ?>)props);
            }
        }

        String getProperty(String key) {
            String overrideProperty = null;
            if (this.useOverride()) {
                overrideProperty = this.props.getProperty(key + ".ondemand");
            }
            return overrideProperty != null ? overrideProperty : this.props.getProperty(key);
        }

        Set<String> propertyNames() {
            return this.props.stringPropertyNames();
        }

        boolean useOverride() {
            return this.useOnDemandOverride && ComponentAccessor.getComponent(FeatureManager.class).isOnDemand();
        }
    }

    @Immutable
    static final class ImmutableHelpPath {
        final String url;
        final String alt;
        final String title;
        final String key;
        final Boolean local;

        ImmutableHelpPath() {
            this(null, null, null, null, null);
        }

        private ImmutableHelpPath(String url, String alt, String title, String key, Boolean local) {
            this.url = url;
            this.alt = alt;
            this.title = title;
            this.key = key;
            this.local = local;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }

        ImmutableHelpPath url(String url) {
            return new ImmutableHelpPath(url, this.alt, this.title, this.key, this.local);
        }

        ImmutableHelpPath alt(String alt) {
            return new ImmutableHelpPath(this.url, alt, this.title, this.key, this.local);
        }

        ImmutableHelpPath title(String title) {
            return new ImmutableHelpPath(this.url, this.alt, title, this.key, this.local);
        }

        ImmutableHelpPath key(String key) {
            return new ImmutableHelpPath(this.url, this.alt, this.title, key, this.local);
        }

        ImmutableHelpPath local(Boolean local) {
            return new ImmutableHelpPath(this.url, this.alt, this.title, this.key, local);
        }
    }
}

