/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CookieUtils {
    private static final Logger LOG = Logger.getLogger(CookieUtils.class);
    private static final Pattern CONGLOMERATE_KEYPAIR_PATTERN = Pattern.compile("^(.+)?=(.+)$");
    public static final String JSESSIONID = "JSESSIONID";
    private static final String MSG_DUPLICATE_SESSION_IDS = "Found multiple JSESSIONID cookies, when rendering link to screenshot applet page. You may have another Java webapp at context path '/' (in which case this message is harmless), or there may be a problem in IE attaching the screenshot via the screenshot applet.";

    public static String getSingleSessionId(Cookie[] cookies) {
        if (cookies == null) {
            return null;
        }
        String sessionId = null;
        boolean foundASessionId = false;
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            if (!JSESSIONID.equals(cookie.getName())) continue;
            if (!foundASessionId) {
                sessionId = cookie.getValue();
                foundASessionId = true;
                continue;
            }
            LOG.debug((Object)MSG_DUPLICATE_SESSION_IDS);
            return null;
        }
        return sessionId;
    }

    public static boolean hasSessionId(Cookie[] cookies) {
        if (cookies == null) {
            return false;
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!JSESSIONID.equals(cookies[i].getName())) continue;
            return true;
        }
        return false;
    }

    public static void setSessionCookie(HttpServletRequest request, HttpServletResponse response, String sessionId) {
        if (sessionId != null) {
            Cookie cookie = new Cookie(JSESSIONID, sessionId);
            cookie.setPath(CookieUtils.cookiePathFor(request));
            response.addCookie(cookie);
        }
    }

    public static String cookiePathFor(HttpServletRequest httpServletRequest) {
        String requestPath = httpServletRequest.getContextPath();
        return StringUtils.isNotEmpty((String)requestPath) ? requestPath : "/";
    }

    public static Cookie createCookie(String name, String value, HttpServletRequest currentRequest) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(CookieUtils.cookiePathFor(currentRequest));
        return cookie;
    }

    public static String getCookieValue(String cookieName, HttpServletRequest currentRequest) {
        Assertions.notNull("cookieName", cookieName);
        Assertions.notNull("currentRequest", currentRequest);
        Cookie[] cookies = currentRequest.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookieName.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public static Map<String, String> parseConglomerateCookie(String cookieName, HttpServletRequest currentRequest) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        String cookieValue = CookieUtils.getCookieValue(cookieName, currentRequest);
        if (StringUtils.isNotBlank((String)cookieValue)) {
            String[] values;
            for (String rawKeyValuePair : values = cookieValue.split("[|]")) {
                Matcher m;
                String keyValuePair;
                if (!StringUtils.isNotBlank((String)rawKeyValuePair) || !StringUtils.isNotBlank((String)(keyValuePair = JiraUrlCodec.decode(rawKeyValuePair, "UTF-8"))) || !(m = CONGLOMERATE_KEYPAIR_PATTERN.matcher(keyValuePair)).matches()) continue;
                String key = m.group(1);
                String value = m.group(2);
                result.put(key, value);
            }
        }
        return result;
    }

    public static Cookie createConglomerateCookie(String cookieName, Map<String, String> map, HttpServletRequest request) {
        StringBuilder cookieValue = new StringBuilder();
        String sep = "";
        for (Map.Entry<String, String> keyValuePair : map.entrySet()) {
            if (!StringUtils.isNotBlank((String)keyValuePair.getValue())) continue;
            String s = JiraUrlCodec.encode(keyValuePair.getKey() + "=" + keyValuePair.getValue(), "UTF-8");
            cookieValue.append(sep).append(s);
            sep = "|";
        }
        Cookie cookie = CookieUtils.createCookie(cookieName, cookieValue.toString(), request);
        cookie.setMaxAge(Integer.MAX_VALUE);
        return cookie;
    }
}

