/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.util;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import java.util.Collection;

public class VersionHelperBean {
    public static final Long UNKNOWN_VERSION_ID = new Long(-1L);
    public static final Long UNRELEASED_VERSION_ID = new Long(-2L);
    public static final Long RELEASED_VERSION_ID = new Long(-3L);
    private VersionManager versionManager;

    public VersionHelperBean(VersionManager versionManager) {
        this.versionManager = versionManager;
    }

    public boolean validateVersionIds(Collection versionIds, ErrorCollection errorCollection, I18nHelper i18n, String fieldId) {
        boolean valid = true;
        if (versionIds != null) {
            if (versionIds.size() > 1 && versionIds.contains(UNKNOWN_VERSION_ID)) {
                errorCollection.addError(fieldId, i18n.getText("issue.field.versions.noneselectedwithother"), ErrorCollection.Reason.VALIDATION_FAILED);
                valid = false;
            }
            for (Object o : versionIds) {
                Long l = this.getVersionIdAsLong(o);
                if (l >= -1L) continue;
                errorCollection.addError(fieldId, i18n.getText("issue.field.versions.releasedunreleasedselected"), ErrorCollection.Reason.VALIDATION_FAILED);
                valid = false;
            }
        }
        return valid;
    }

    public void validateVersionForProject(Collection versionIds, Project project, ErrorCollection errorCollection, I18nHelper i18n, String fieldId) {
        if (versionIds != null && project != null) {
            Long projectId = project.getId();
            StringBuilder sb = null;
            for (Object versionId : versionIds) {
                Long id = this.getVersionIdAsLong(versionId);
                if (id == -1L) {
                    return;
                }
                Version version = this.versionManager.getVersion(id);
                if (version == null) {
                    errorCollection.addError(fieldId, i18n.getText("issue.field.versions.invalid.version.id", id), ErrorCollection.Reason.VALIDATION_FAILED);
                    return;
                }
                Long versionProjectId = version.getProjectObject().getId();
                if (versionProjectId.equals(projectId)) continue;
                if (sb == null) {
                    sb = new StringBuilder(version.getName()).append("(").append(version.getId()).append(")");
                    continue;
                }
                sb.append(", ").append(version.getName()).append("(").append(version.getId()).append(")");
            }
            if (sb != null) {
                errorCollection.addError(fieldId, i18n.getText("issue.field.versions.versions.not.valid.for.project", sb.toString(), project.getName()), ErrorCollection.Reason.VALIDATION_FAILED);
            }
        }
    }

    private Long getVersionIdAsLong(Object o) {
        Long l = o instanceof String ? new Long((String)o) : (Long)o;
        return l;
    }
}

