/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail.settings;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MailSetting {
    private static final Logger log = LoggerFactory.getLogger(MailSetting.class);
    private final ApplicationProperties applicationProperties;
    private final String name;

    public MailSetting(@Nonnull ApplicationProperties applicationProperties, @Nonnull String name) {
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties);
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public boolean getValue() {
        return this.applicationProperties.getOption(this.name);
    }

    public void setValue(boolean value) {
        this.applicationProperties.setOption(this.name, value);
        log.info("Mail setting '{}' has been set to '{}'", (Object)this.name, (Object)value);
        if (log.isDebugEnabled()) {
            log.trace("Dumping stack trace for mail setting change", new Throwable());
        }
    }
}

