/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.jql.context.AllIssueTypesContext;
import com.atlassian.jira.jql.context.AllProjectsContext;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.IssueTypeContextImpl;
import com.atlassian.jira.jql.context.ProjectContextImpl;
import com.atlassian.jira.jql.context.ProjectIssueTypeContext;
import com.atlassian.jira.jql.context.ProjectIssueTypeContextImpl;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.InjectableComponent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

@InjectableComponent
public class FieldConfigSchemeClauseContextUtil {
    private static final Logger log = Logger.getLogger(FieldConfigSchemeClauseContextUtil.class);
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final ConstantsManager constantsManager;
    private final PermissionManager permissionManager;
    private final ProjectFactory projectFactory;

    public FieldConfigSchemeClauseContextUtil(IssueTypeSchemeManager issueTypeSchemeManager, ConstantsManager constantsManager, PermissionManager permissionManager, ProjectFactory projectFactory) {
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.constantsManager = constantsManager;
        this.permissionManager = permissionManager;
        this.projectFactory = projectFactory;
    }

    public boolean isConfigSchemeVisibleUnderContext(QueryContext queryContext, FieldConfigScheme fieldConfigScheme) {
        if (fieldConfigScheme.isGlobal()) {
            return true;
        }
        if (fieldConfigScheme.isAllIssueTypes()) {
            return this.fieldConfigSchemeContainsContextProjects(queryContext, fieldConfigScheme);
        }
        if (fieldConfigScheme.isAllProjects()) {
            return this.fieldConfigSchemeContainsContextIssueTypes(queryContext, fieldConfigScheme);
        }
        return this.fieldConfigSchemeContainsContextMapping(queryContext, fieldConfigScheme);
    }

    public FieldConfigScheme getFieldConfigSchemeFromContext(QueryContext queryContext, CustomField customField) {
        FieldConfigScheme mostSpecific = null;
        List<FieldConfigScheme> fieldConfigSchemes = customField.getConfigurationSchemes();
        for (FieldConfigScheme fieldConfigScheme : fieldConfigSchemes) {
            if (!this.isConfigSchemeVisibleUnderContext(queryContext, fieldConfigScheme) || mostSpecific != null && !this.moreSpecific(mostSpecific, fieldConfigScheme)) continue;
            mostSpecific = fieldConfigScheme;
        }
        return mostSpecific;
    }

    public ClauseContext getContextForConfigScheme(User searcher, FieldConfigScheme fieldConfigScheme) {
        Set<ProjectIssueTypeContext> projectIssueTypeContextSet;
        if (fieldConfigScheme.isAllProjects()) {
            projectIssueTypeContextSet = fieldConfigScheme.isAllIssueTypes() ? Collections.singleton(ProjectIssueTypeContextImpl.createGlobalContext()) : this.addProjectIssueTypeContextsForIssueTypesOnly(fieldConfigScheme);
        } else {
            Collection<Project> visibleProjects = this.permissionManager.getProjectObjects(10, searcher);
            List<Project> fieldConfigSchemeProjects = fieldConfigScheme.getAssociatedProjectObjects();
            if (fieldConfigSchemeProjects == null) {
                fieldConfigSchemeProjects = Collections.emptyList();
            }
            Collection associatedProjects = CollectionUtils.intersection(visibleProjects, fieldConfigSchemeProjects);
            projectIssueTypeContextSet = this.addProjectIssueTypeContextsForProjects(fieldConfigScheme, associatedProjects);
        }
        return new ClauseContextImpl(projectIssueTypeContextSet);
    }

    boolean fieldConfigSchemeContainsContextProjects(QueryContext queryContext, FieldConfigScheme fieldConfigScheme) {
        Collection<QueryContext.ProjectIssueTypeContexts> contexts = queryContext.getProjectIssueTypeContexts();
        HashSet<Long> projectIdsInContext = new HashSet<Long>();
        for (QueryContext.ProjectIssueTypeContexts context : contexts) {
            projectIdsInContext.addAll(context.getProjectIdInList());
        }
        Set<Long> projectIdsInScheme = this.getProjectIdsForScheme(fieldConfigScheme);
        return !CollectionUtils.intersection(projectIdsInContext, projectIdsInScheme).isEmpty();
    }

    boolean fieldConfigSchemeContainsContextIssueTypes(QueryContext queryContext, FieldConfigScheme fieldConfigScheme) {
        Collection<QueryContext.ProjectIssueTypeContexts> contexts = queryContext.getProjectIssueTypeContexts();
        HashSet<String> issueTypeIdsInContext = new HashSet<String>();
        for (QueryContext.ProjectIssueTypeContexts context : contexts) {
            issueTypeIdsInContext.addAll(context.getIssueTypeIds());
        }
        Set<String> issueTypeIdsInScheme = this.getIssueTypeIdsForScheme(fieldConfigScheme);
        return !CollectionUtils.intersection(issueTypeIdsInContext, issueTypeIdsInScheme).isEmpty();
    }

    boolean fieldConfigSchemeContainsContextMapping(QueryContext queryContext, FieldConfigScheme fieldConfigScheme) {
        Set<Long> projectIdsForScheme = this.getProjectIdsForScheme(fieldConfigScheme);
        Set<String> issueTypeIdsForScheme = this.getIssueTypeIdsForScheme(fieldConfigScheme);
        Collection<QueryContext.ProjectIssueTypeContexts> contexts = queryContext.getProjectIssueTypeContexts();
        for (QueryContext.ProjectIssueTypeContexts context : contexts) {
            List<String> contextIssueTypeIds;
            if (context.getProjectContext().isAll() || !projectIdsForScheme.containsAll(context.getProjectIdInList()) || !CollectionUtils.containsAny(issueTypeIdsForScheme, contextIssueTypeIds = context.getIssueTypeIds())) continue;
            return true;
        }
        return false;
    }

    Set<Long> getProjectIdsForScheme(FieldConfigScheme fieldConfigScheme) {
        List<Project> projects = fieldConfigScheme.getAssociatedProjectObjects();
        HashSet<Long> projectIdsInScheme = new HashSet<Long>();
        if (projects != null) {
            for (Project project : projects) {
                projectIdsInScheme.add(project.getId());
            }
        }
        return projectIdsInScheme;
    }

    Set<String> getIssueTypeIdsForScheme(FieldConfigScheme fieldConfigScheme) {
        Set<GenericValue> issueTypeGVs = fieldConfigScheme.getAssociatedIssueTypes();
        HashSet<String> issueTypeIdsInScheme = new HashSet<String>();
        if (issueTypeGVs == null) {
            log.debug((Object)"Custom field context with no valid issue types encountered, this context will be ignored, see http://jira.atlassian.com/browse/JRA-10461 for details");
        } else {
            for (GenericValue issueTypeGV : issueTypeGVs) {
                issueTypeIdsInScheme.add(issueTypeGV.getString("id"));
            }
        }
        return issueTypeIdsInScheme;
    }

    Set<ProjectIssueTypeContext> addProjectIssueTypeContextsForProjects(FieldConfigScheme fieldConfigScheme, Collection<Project> associatedProjects) {
        HashSet<ProjectIssueTypeContext> relevantContexts = new HashSet<ProjectIssueTypeContext>();
        for (Project associatedProject : associatedProjects) {
            Long projectId = associatedProject.getId();
            if (fieldConfigScheme.isAllIssueTypes()) {
                ProjectIssueTypeContextImpl projectIssueTypeContext = new ProjectIssueTypeContextImpl(new ProjectContextImpl(projectId), AllIssueTypesContext.INSTANCE);
                relevantContexts.add(projectIssueTypeContext);
                continue;
            }
            if (fieldConfigScheme.getAssociatedIssueTypes() == null) {
                log.debug((Object)"Custom field context with no valid issue types encountered, this context will be ignored, see http://jira.atlassian.com/browse/JRA-10461 for details");
                continue;
            }
            Collection<IssueType> projectIssueTypes = this.issueTypeSchemeManager.getIssueTypesForProject(associatedProject);
            Set<GenericValue> associatedIssueTypeGvs = fieldConfigScheme.getAssociatedIssueTypes();
            for (GenericValue associatedIssueTypeGv : associatedIssueTypeGvs) {
                String issueTypeId = associatedIssueTypeGv.getString("id");
                IssueType associatedIssueType = this.constantsManager.getIssueTypeObject(issueTypeId);
                if (!projectIssueTypes.contains(associatedIssueType)) continue;
                ProjectIssueTypeContextImpl projectIssueTypeContext = new ProjectIssueTypeContextImpl(new ProjectContextImpl(projectId), new IssueTypeContextImpl(issueTypeId));
                relevantContexts.add(projectIssueTypeContext);
            }
        }
        return relevantContexts;
    }

    Set<ProjectIssueTypeContext> addProjectIssueTypeContextsForIssueTypesOnly(FieldConfigScheme fieldConfigScheme) {
        Set<GenericValue> associatedIssueTypeGvs = fieldConfigScheme.getAssociatedIssueTypes();
        LinkedHashSet<ProjectIssueTypeContext> contexts = new LinkedHashSet<ProjectIssueTypeContext>();
        if (associatedIssueTypeGvs == null) {
            log.debug((Object)"Custom field context with no valid issue types encountered, this context will be ignored, see http://jira.atlassian.com/browse/JRA-10461 for details");
        } else {
            for (GenericValue associatedIssueTypeGv : associatedIssueTypeGvs) {
                String issueTypeId = associatedIssueTypeGv.getString("id");
                contexts.add(new ProjectIssueTypeContextImpl(AllProjectsContext.INSTANCE, new IssueTypeContextImpl(issueTypeId)));
            }
        }
        return contexts;
    }

    private boolean moreSpecific(FieldConfigScheme scheme1, FieldConfigScheme scheme2) {
        if (scheme1.isGlobal()) {
            return true;
        }
        if (scheme1.isAllProjects()) {
            return !scheme2.isAllIssueTypes() || !scheme2.isAllProjects();
        }
        if (scheme1.isAllIssueTypes()) {
            return !scheme2.isAllProjects();
        }
        return !scheme2.isAllIssueTypes() && !scheme2.isAllProjects();
    }
}

