/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.changehistory;

import com.atlassian.annotations.PublicApi;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.sql.Timestamp;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@Immutable
@PublicApi
public class ChangeHistoryItem
implements Comparable<ChangeHistoryItem> {
    private final Long id;
    private final Long changeGroupId;
    private final String userKey;
    private final String field;
    private final Long projectId;
    private final Long issueId;
    private final String issueKey;
    private final Timestamp created;
    private final Timestamp nextChangeCreated;
    private final Map<String, String> fromValues;
    private final Map<String, String> toValues;
    private static final Timestamp TS_MAX = new Timestamp(Long.MAX_VALUE);

    public ChangeHistoryItem(Long id, Long changeGroupId, Long projectId, Long issueId, String issueKey, String field, Timestamp created, String from, String to, String fromValue, String toValue, String userKey) {
        this(id, changeGroupId, projectId, issueId, issueKey, field, created, new Timestamp(Long.MAX_VALUE), from, to, fromValue, toValue, userKey);
    }

    public ChangeHistoryItem(Long id, Long changeGroupId, Long projectId, Long issueId, String issueKey, String field, Timestamp created, Timestamp nextChange, String from, String to, String fromValue, String toValue, String userKey) {
        this.fromValues = Maps.newHashMap();
        this.toValues = Maps.newHashMap();
        this.field = field;
        this.id = id;
        this.changeGroupId = changeGroupId;
        this.userKey = userKey;
        this.projectId = projectId;
        this.issueId = issueId;
        this.issueKey = issueKey;
        this.created = created;
        this.nextChangeCreated = nextChange;
        if (fromValue != null) {
            this.fromValues.put(fromValue, from == null ? "" : from);
        }
        if (toValue != null) {
            this.toValues.put(toValue, to == null ? "" : to);
        }
    }

    private ChangeHistoryItem(Long id, Long changeGroupId, Long projectId, Long issueId, String issueKey, String field, Timestamp created, Timestamp nextChange, Map<String, String> fromValues, Map<String, String> toValues, String userKey) {
        this.fromValues = fromValues;
        this.toValues = toValues;
        this.id = id;
        this.changeGroupId = changeGroupId;
        this.userKey = userKey;
        this.projectId = projectId;
        this.issueId = issueId;
        this.issueKey = issueKey;
        this.created = created;
        this.nextChangeCreated = nextChange;
        this.field = field;
    }

    public Long getId() {
        return this.id;
    }

    public Long getChangeGroupId() {
        return this.changeGroupId;
    }

    @Deprecated
    public String getUser() {
        return this.userKey;
    }

    public String getUserKey() {
        return this.userKey;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public Long getIssueId() {
        return this.issueId;
    }

    public String getIssueKey() {
        return this.issueKey;
    }

    public Timestamp getCreated() {
        return this.created;
    }

    @Deprecated
    public String getFrom() {
        String from = null;
        if (this.fromValues.size() > 0) {
            from = this.fromValues.values().iterator().next();
        }
        return from;
    }

    @Deprecated
    public String getTo() {
        String to = null;
        if (this.toValues.size() > 0) {
            to = this.toValues.values().iterator().next();
        }
        return to;
    }

    @Deprecated
    public String getFromValue() {
        String fromValue = null;
        if (this.fromValues.size() > 0) {
            fromValue = this.fromValues.keySet().iterator().next();
        }
        return fromValue;
    }

    @Deprecated
    public String getToValue() {
        String toValue = null;
        if (this.toValues.size() > 0) {
            toValue = this.toValues.keySet().iterator().next();
        }
        return toValue;
    }

    public Map<String, String> getFroms() {
        return ImmutableMap.copyOf(this.fromValues);
    }

    public Map<String, String> getTos() {
        return ImmutableMap.copyOf(this.toValues);
    }

    public String getField() {
        return this.field;
    }

    public Timestamp getNextChangeCreated() {
        return this.nextChangeCreated;
    }

    public Long getDuration() {
        if (this.nextChangeCreated.equals(TS_MAX)) {
            return -1L;
        }
        return this.nextChangeCreated.getTime() - this.created.getTime();
    }

    public boolean containsFromValue(String fromValue) {
        return this.fromValues.keySet().contains(fromValue);
    }

    public boolean containsToValue(String toValue) {
        return this.toValues.keySet().contains(toValue);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ChangeHistoryItem)) {
            return false;
        }
        ChangeHistoryItem rhs = (ChangeHistoryItem)o;
        return new EqualsBuilder().append((Object)this.getId(), (Object)rhs.getId()).append((Object)this.getChangeGroupId(), (Object)rhs.getChangeGroupId()).append((Object)this.getField(), (Object)rhs.getField()).append((Object)this.getUserKey(), (Object)rhs.getUserKey()).append((Object)this.getProjectId(), (Object)rhs.getProjectId()).append((Object)this.getIssueId(), (Object)rhs.getIssueId()).append((Object)this.getIssueKey(), (Object)rhs.getIssueKey()).append((Object)this.getCreated(), (Object)rhs.getCreated()).append((Object)this.getNextChangeCreated(), (Object)rhs.getNextChangeCreated()).append(this.getFroms(), rhs.getFroms()).append(this.getTos(), rhs.getTos()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getId()).append((Object)this.getChangeGroupId()).append((Object)this.getField()).append((Object)this.getUserKey()).append((Object)this.getProjectId()).append((Object)this.getIssueId()).append((Object)this.getIssueKey()).append((Object)this.getCreated()).append((Object)this.getNextChangeCreated()).append(this.getFroms()).append(this.getTos()).toHashCode();
    }

    @Override
    public int compareTo(ChangeHistoryItem other) {
        if (this.changeGroupId.compareTo(other.getChangeGroupId()) == 0) {
            return this.id.compareTo(other.getId());
        }
        return this.created.compareTo(other.getCreated());
    }

    public static class Builder {
        private Long id;
        private Long changeGroupId;
        private Long projectId;
        private Long issueId;
        private String issueKey;
        private String field;
        private Timestamp created;
        private Map<String, String> fromValues = Maps.newHashMap();
        private Map<String, String> toValues = Maps.newHashMap();
        private String userKey;
        private Timestamp nextChangeCreated = new Timestamp(Long.MAX_VALUE);

        public Builder fromChangeItem(ChangeHistoryItem changeItem) {
            this.fromChangeItemWithoutPreservingChanges(changeItem);
            this.fromValues = Maps.newHashMap(changeItem.getFroms());
            this.toValues = Maps.newHashMap(changeItem.getTos());
            return this;
        }

        public Builder fromChangeItemWithoutPreservingChanges(ChangeHistoryItem changeItem) {
            this.id = changeItem.getId();
            this.projectId = changeItem.getProjectId();
            this.changeGroupId = changeItem.getChangeGroupId();
            this.issueId = changeItem.getIssueId();
            this.issueKey = changeItem.getIssueKey();
            this.field = changeItem.getField();
            this.created = changeItem.getCreated();
            this.userKey = changeItem.getUserKey();
            this.nextChangeCreated = changeItem.getNextChangeCreated();
            return this;
        }

        public Builder fromChangeItemPreservingFromValues(ChangeHistoryItem changeItem) {
            this.fromChangeItemWithoutPreservingChanges(changeItem);
            this.fromValues = Maps.newHashMap(changeItem.getFroms());
            return this;
        }

        public Builder fromChangeItemPreservingToValues(ChangeHistoryItem changeItem) {
            this.fromChangeItemWithoutPreservingChanges(changeItem);
            this.toValues = Maps.newHashMap(changeItem.getTos());
            return this;
        }

        public Builder withId(Long id) {
            this.id = id;
            return this;
        }

        public Builder withId(long id) {
            return this.withId((Long)id);
        }

        public Builder inChangeGroup(Long id) {
            Preconditions.checkNotNull((Object)id);
            this.changeGroupId = id;
            return this;
        }

        public Builder inChangeGroup(long id) {
            return this.inChangeGroup((Long)id);
        }

        public Builder inProject(Long projectId) {
            Preconditions.checkNotNull((Object)projectId);
            this.projectId = projectId;
            return this;
        }

        public Builder inProject(long projectId) {
            return this.inProject((Long)projectId);
        }

        public Builder forIssue(Long issueId, String issueKey) {
            Preconditions.checkNotNull((Object)issueId);
            this.issueId = issueId;
            this.issueKey = issueKey == null ? "" : issueKey;
            return this;
        }

        public Builder forIssue(long issueId, String issueKey) {
            return this.forIssue((Long)issueId, issueKey);
        }

        public Builder field(String field) {
            Preconditions.checkNotNull((Object)field);
            this.field = field;
            return this;
        }

        public Builder changedFrom(String from, String fromValue) {
            if (fromValue != null) {
                this.fromValues.put(fromValue, from == null ? "" : from);
            }
            return this;
        }

        public Builder to(String to, String toValue) {
            if (toValue != null) {
                this.toValues.put(toValue, to == null ? "" : to);
            }
            return this;
        }

        public Builder byUser(String userKey) {
            this.userKey = userKey;
            return this;
        }

        public Builder on(Timestamp created) {
            Preconditions.checkNotNull((Object)created);
            this.created = created;
            return this;
        }

        public Builder nextChangeOn(Timestamp nextChangeCreated) {
            this.nextChangeCreated = nextChangeCreated;
            return this;
        }

        public Builder withTos(Map<String, String> tos) {
            this.toValues = Maps.newHashMap(tos);
            return this;
        }

        public Builder withFroms(Map<String, String> froms) {
            this.fromValues = Maps.newHashMap(froms);
            return this;
        }

        public ChangeHistoryItem build() {
            return new ChangeHistoryItem(this.id, this.changeGroupId, this.projectId, this.issueId, this.issueKey, this.field, this.created, this.nextChangeCreated, this.fromValues, this.toValues, this.userKey);
        }
    }
}

