/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics;

import com.atlassian.jira.issue.comparator.OfBizComparators;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestAppender;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstants;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.util.SearchRequestAddendumBuilder;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operator.Operator;
import com.google.common.base.Preconditions;
import java.util.Comparator;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;

public class ProjectStatisticsMapper
implements StatisticsMapper,
SearchRequestAppender.Factory<GenericValue> {
    private final ProjectManager projectManager;
    private final String clauseName;
    private final String documentConstant;

    public ProjectStatisticsMapper(ProjectManager projectManager) {
        this(projectManager, SystemSearchConstants.forProject());
    }

    public ProjectStatisticsMapper(ProjectManager projectManager, SimpleFieldSearchConstants searchConstants) {
        this(projectManager, searchConstants.getJqlClauseNames().getPrimaryName(), searchConstants.getIndexField());
    }

    public ProjectStatisticsMapper(ProjectManager projectManager, String clauseName, String documentConstant) {
        this.projectManager = projectManager;
        this.clauseName = clauseName;
        this.documentConstant = documentConstant;
    }

    @Override
    public String getDocumentConstant() {
        return this.documentConstant;
    }

    @Override
    public Object getValueFromLuceneField(String documentValue) {
        long projectId;
        if (StringUtils.isNotBlank((String)documentValue) && (projectId = Long.parseLong(documentValue)) > 0L) {
            return this.projectManager.getProject(projectId);
        }
        return null;
    }

    @Override
    public Comparator getComparator() {
        return OfBizComparators.NAME_COMPARATOR;
    }

    public boolean isValidValue(Object value) {
        return true;
    }

    @Override
    public boolean isFieldAlwaysPartOfAnIssue() {
        return true;
    }

    @Deprecated
    public SearchRequest getSearchUrlSuffix(Object value, SearchRequest searchRequest) {
        return this.getSearchRequestAppender().appendInclusiveSingleValueClause((GenericValue)value, searchRequest);
    }

    @Override
    public SearchRequestAppender<GenericValue> getSearchRequestAppender() {
        return new ProjectSearchRequestAppender(this.projectManager, this.getClauseName());
    }

    protected String getClauseName() {
        return this.clauseName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectStatisticsMapper that = (ProjectStatisticsMapper)o;
        return this.getDocumentConstant() != null ? this.getDocumentConstant().equals(that.getDocumentConstant()) : that.getDocumentConstant() == null;
    }

    @Override
    public int hashCode() {
        return this.getDocumentConstant() != null ? this.getDocumentConstant().hashCode() : 0;
    }

    static class ProjectSearchRequestAppender
    implements SearchRequestAddendumBuilder.AddendumCallback<GenericValue>,
    SearchRequestAppender<GenericValue> {
        private final ProjectManager projectManager;
        private final String clauseName;

        public ProjectSearchRequestAppender(ProjectManager projectManager, String clauseName) {
            this.projectManager = (ProjectManager)Preconditions.checkNotNull((Object)projectManager);
            this.clauseName = (String)Preconditions.checkNotNull((Object)clauseName);
        }

        @Override
        public void appendNonNullItem(GenericValue value, JqlClauseBuilder clauseBuilder) {
            Long projectId = value.getLong("id");
            Project project = this.projectManager.getProjectObj(projectId);
            clauseBuilder.addClause(new TerminalClauseImpl(this.clauseName, Operator.EQUALS, project.getKey()));
        }

        @Override
        public void appendNullItem(JqlClauseBuilder clauseBuilder) {
            clauseBuilder.addEmptyCondition(this.clauseName);
        }

        @Override
        public SearchRequest appendInclusiveSingleValueClause(GenericValue value, SearchRequest searchRequest) {
            return SearchRequestAddendumBuilder.appendAndClause(value, searchRequest, this);
        }

        @Override
        public SearchRequest appendExclusiveMultiValueClause(Iterable values, SearchRequest searchRequest) {
            return SearchRequestAddendumBuilder.appendAndNotClauses(values, searchRequest, this);
        }
    }
}

