/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.roles.actor;

import com.atlassian.annotations.Internal;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.security.roles.ProjectRoleActor;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.security.roles.RoleActorDoesNotExistException;
import com.atlassian.jira.security.roles.RoleActorFactory;
import com.atlassian.jira.security.roles.actor.AbstractRoleActor;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@Internal
public class UserRoleActorFactory
implements RoleActorFactory {
    public static final String TYPE = "atlassian-user-role-actor";
    private final UserFactory userFactory;
    private final CrowdService crowdService;

    public UserRoleActorFactory(final CrowdService crowdService) {
        this(new UserFactory(){

            @Override
            public User getUser(String name) {
                return crowdService.getUser(name);
            }
        }, crowdService);
    }

    UserRoleActorFactory(UserFactory userFactory, CrowdService crowdService) {
        if (userFactory == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " cannot be constructed without a UserFactory instance");
        }
        this.userFactory = userFactory;
        this.crowdService = crowdService;
    }

    @Override
    public ProjectRoleActor createRoleActor(Long id, Long projectRoleId, Long projectId, String type, String parameter) throws RoleActorDoesNotExistException {
        if (!TYPE.equals(type)) {
            throw new IllegalArgumentException(this.getClass().getName() + " cannot create RoleActors of type: " + type);
        }
        Assertions.notNull("parameter", parameter);
        User user = this.userFactory.getUser(parameter);
        if (user == null) {
            throw new RoleActorDoesNotExistException("User '" + parameter + "' does not exist.");
        }
        return new UserRoleActor(id, projectRoleId, projectId, user);
    }

    public Set optimizeRoleActorSet(Set roleActors) {
        HashSet<AggregateRoleActor> originals = new HashSet<AggregateRoleActor>(roleActors);
        HashSet<ProjectRoleActor> userRoleActors = new HashSet<ProjectRoleActor>(roleActors.size());
        Iterator it = originals.iterator();
        while (it.hasNext()) {
            ProjectRoleActor roleActor = (ProjectRoleActor)it.next();
            if (!(roleActor instanceof UserRoleActor)) continue;
            userRoleActors.add(roleActor);
            it.remove();
        }
        if (!userRoleActors.isEmpty()) {
            if (userRoleActors.size() > 1) {
                UserRoleActor roleActor = (UserRoleActor)userRoleActors.iterator().next();
                originals.add(new AggregateRoleActor(roleActor, userRoleActors));
            } else {
                originals.addAll(userRoleActors);
            }
        }
        return Collections.unmodifiableSet(originals);
    }

    static interface UserFactory {
        public User getUser(String var1);
    }

    static class AggregateRoleActor
    extends AbstractRoleActor {
        private final Map userRoleActorMap;

        private AggregateRoleActor(ProjectRoleActor prototype, Set roleActors) {
            super(null, prototype.getProjectRoleId(), prototype.getProjectId(), null);
            HashMap<String, UserRoleActor> map = new HashMap<String, UserRoleActor>(roleActors.size());
            for (UserRoleActor userRoleActor : roleActors) {
                map.put(userRoleActor.getParameter(), userRoleActor);
            }
            this.userRoleActorMap = Collections.unmodifiableMap(map);
        }

        @Override
        public boolean contains(User user) {
            return user != null && this.userRoleActorMap.containsKey(user.getName()) && ((RoleActor)this.userRoleActorMap.get(user.getName())).contains(user);
        }

        @Override
        public Set<User> getUsers() {
            HashSet<User> result = new HashSet<User>(this.userRoleActorMap.size());
            for (UserRoleActor roleActor : this.userRoleActorMap.values()) {
                result.addAll(roleActor.getUsers());
            }
            return Collections.unmodifiableSet(result);
        }

        @Override
        public String getType() {
            return UserRoleActorFactory.TYPE;
        }
    }

    class UserRoleActor
    extends AbstractRoleActor {
        private final User user;

        private UserRoleActor(Long id, Long projectRoleId, Long projectId, User user) {
            super(id, projectRoleId, projectId, user.getName());
            this.user = user;
        }

        @Override
        public String getType() {
            return UserRoleActorFactory.TYPE;
        }

        @Override
        public String getDescriptor() {
            return this.user.getDisplayName();
        }

        @Override
        public Set<User> getUsers() {
            return CollectionBuilder.newBuilder(this.user).asSet();
        }

        @Override
        public boolean contains(User user) {
            return user != null && this.getParameter().equals(user.getName());
        }
    }
}

