/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics.util;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.statistics.util.FieldValueToDisplayTransformer;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.util.I18nHelper;
import org.ofbiz.core.entity.GenericValue;

public class DefaultFieldValueToDisplayTransformer
implements FieldValueToDisplayTransformer<String> {
    private final I18nHelper i18nBean;
    private final ConstantsManager constantsManager;
    private final CustomFieldManager customFieldManager;

    public DefaultFieldValueToDisplayTransformer(I18nHelper i18nBean, ConstantsManager constantsManager, CustomFieldManager customFieldManager) {
        this.i18nBean = i18nBean;
        this.constantsManager = constantsManager;
        this.customFieldManager = customFieldManager;
    }

    @Override
    public String transformFromIrrelevant(String fieldType, Object input, String url) {
        return this.i18nBean.getText("common.concepts.irrelevant");
    }

    @Override
    public String transformFromProject(String fieldType, Object input, String url) {
        return ((GenericValue)input).getString("name");
    }

    @Override
    public String transformFromAssignee(String fieldType, Object input, String url) {
        if (input == null) {
            return this.i18nBean.getText("gadget.filterstats.assignee.unassigned");
        }
        return ((User)input).getDisplayName().trim();
    }

    @Override
    public String transformFromReporter(String fieldType, Object input, String url) {
        if (input == null) {
            return this.i18nBean.getText("gadget.filterstats.reporter.unknown");
        }
        return ((User)input).getDisplayName().trim();
    }

    @Override
    public String transformFromResolution(String fieldType, Object input, String url) {
        if (input == null) {
            return this.i18nBean.getText("common.resolution.unresolved");
        }
        return ((IssueConstant)input).getNameTranslation().trim();
    }

    @Override
    public String transformFromPriority(String fieldType, Object input, String url) {
        if (input == null) {
            return this.i18nBean.getText("gadget.filterstats.priority.nopriority");
        }
        return ((IssueConstant)input).getNameTranslation().trim();
    }

    @Override
    public String transformFromIssueType(String fieldType, Object input, String url) {
        return ((IssueConstant)input).getNameTranslation();
    }

    @Override
    public String transformFromStatus(String fieldType, Object input, String url) {
        return ((IssueConstant)input).getNameTranslation();
    }

    @Override
    public String transformFromComponent(String fieldType, Object input, String url) {
        if (input == null) {
            return this.i18nBean.getText("gadget.filterstats.component.nocomponent");
        }
        return ((GenericValue)input).getString("name").trim();
    }

    @Override
    public String transformFromVersion(String fieldType, Object input, String url) {
        if (input == null) {
            return this.i18nBean.getText("gadget.filterstats.raisedin.unscheduled");
        }
        return ((Version)input).getName().trim();
    }

    @Override
    public String transformFromFixFor(String fieldType, Object input, String url) {
        if (input == null) {
            return this.i18nBean.getText("gadget.filterstats.fixfor.unscheduled");
        }
        return ((Version)input).getName().trim();
    }

    @Override
    public String transformFromLabels(String fieldType, Object input, String url) {
        if (input == null) {
            return this.i18nBean.getText("gadget.filterstats.labels.none");
        }
        return ((Label)input).getLabel().trim();
    }

    @Override
    public String transformFromCustomField(String fieldType, Object input, String url) {
        if (input == null) {
            return this.i18nBean.getText("common.words.none");
        }
        CustomField customFieldObject = this.customFieldManager.getCustomFieldObject(fieldType);
        return customFieldObject.getCustomFieldSearcher().getDescriptor().getStatHtml(customFieldObject, input, null).trim();
    }
}

