/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuetabpanel;

import com.atlassian.annotations.Internal;
import com.atlassian.annotations.PublicApi;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@PublicApi
@Immutable
public final class GetActionsRequest {
    private final Issue issue;
    private final User remoteUser;
    private final boolean asynchronous;

    @Internal
    public GetActionsRequest(@Nonnull Issue issue, @Nullable User remoteUser, boolean asynchronous) {
        this.issue = (Issue)Preconditions.checkNotNull((Object)issue);
        this.remoteUser = remoteUser;
        this.asynchronous = asynchronous;
    }

    @Nonnull
    public Issue issue() {
        return this.issue;
    }

    @Nullable
    public User remoteUser() {
        return this.remoteUser;
    }

    public boolean isAnonymous() {
        return this.remoteUser() == null;
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public ApplicationUser loggedInUser() {
        return ApplicationUsers.from(this.remoteUser);
    }
}

