/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.util.NotNull;

@PublicApi
public interface Avatar {
    @NotNull
    public Type getAvatarType();

    @NotNull
    public String getFileName();

    @NotNull
    public String getContentType();

    public Long getId();

    @NotNull
    public String getOwner();

    public boolean isSystemAvatar();

    public static enum Size {
        SMALL("small", false, 16),
        LARGE("large", true, 48);

        final String param;
        final Integer pixels;
        final boolean isDefault;

        private Size(String param, boolean isDefault, int pixels) {
            this.param = param;
            this.isDefault = isDefault;
            this.pixels = pixels;
        }
    }

    public static enum Type {
        PROJECT("project"),
        USER("user");

        private String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static Type getByName(String name) {
            if (name == null) {
                return null;
            }
            if (PROJECT.getName().equals(name)) {
                return PROJECT;
            }
            if (USER.getName().equals(name)) {
                return USER;
            }
            return null;
        }
    }
}

