/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.JiraUrlCodec;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonProperty;

public class ProjectJsonBean {
    @JsonProperty
    private String self;
    @JsonProperty
    private String id;
    @JsonProperty
    private String key;
    @JsonProperty
    private String name;
    @JsonProperty
    private Map<String, String> avatarUrls;

    public String getSelf() {
        return this.self;
    }

    public String getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getAvatarUrls() {
        return this.avatarUrls;
    }

    public static ProjectJsonBean shortBean(Project project, JiraBaseUrls urls) {
        if (project == null) {
            return null;
        }
        ProjectJsonBean bean = new ProjectJsonBean();
        bean.self = urls.restApi2BaseUrl() + "project/" + JiraUrlCodec.encode(project.getKey());
        bean.id = project.getId().toString();
        bean.key = project.getKey();
        bean.name = project.getName();
        bean.avatarUrls = ProjectJsonBean.getAvatarUrls(project);
        return bean;
    }

    public static Map<String, String> getAvatarUrls(Project project) {
        AvatarService avatarService = ComponentAccessor.getAvatarService();
        Avatar avatar = project.getAvatar();
        if (avatar == null) {
            return null;
        }
        HashMap<String, String> avatarUrls = new HashMap<String, String>();
        for (Avatar.Size size : Avatar.Size.values()) {
            int px = size.getPixels();
            String sizeName = String.format("%dx%d", px, px);
            avatarUrls.put(sizeName, avatarService.getProjectAvatarAbsoluteURL(project, size).toString());
        }
        return avatarUrls;
    }

    public static Collection<ProjectJsonBean> shortBeans(Collection<Project> allowedValues, JiraBaseUrls baseUrls) {
        ArrayList result = Lists.newArrayListWithCapacity((int)allowedValues.size());
        for (Project from : allowedValues) {
            result.add(ProjectJsonBean.shortBean(from, baseUrls));
        }
        return result;
    }
}

