/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.util.NotNull;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@PublicApi
public interface Avatar {
    @NotNull
    public Type getAvatarType();

    @NotNull
    public String getFileName();

    @NotNull
    public String getContentType();

    public Long getId();

    @NotNull
    public String getOwner();

    public boolean isSystemAvatar();

    public static enum Size {
        NORMAL("small", 24),
        SMALL("xsmall", 16),
        MEDIUM("medium", 32),
        LARGE("large", 48, true),
        XLARGE("xlarge", 64),
        XXLARGE("xxlarge", 96),
        XXXLARGE("xxxlarge", 128),
        RETINA_XXLARGE("xxlarge@2x", 192),
        RETINA_XXXLARGE("xxxlarge@2x", 256);

        final String param;
        final Integer pixels;
        final boolean isDefault;
        private static final Size largest;
        private static final Size defaultSize;
        private static final List<Size> orderedSizes;

        private Size(String param, int pixels, boolean isDefault) {
            this.param = param;
            this.isDefault = isDefault;
            this.pixels = pixels;
        }

        private Size(String param, int pixels) {
            this(param, pixels, false);
        }

        public static Size largest() {
            return largest;
        }

        public static Size defaultSize() {
            return defaultSize;
        }

        public static Size biggerThan(int pixelValue) {
            Size theSize = null;
            for (Size aSize : Size.inPixelOrder()) {
                if (aSize.pixels < pixelValue) continue;
                theSize = aSize;
                break;
            }
            return theSize;
        }

        public static Size smallerThan(int pixelValue) {
            Size theSize = null;
            for (Size aSize : Lists.reverse(Size.inPixelOrder())) {
                if (aSize.pixels > pixelValue) continue;
                theSize = aSize;
                break;
            }
            return theSize;
        }

        static List<Size> inPixelOrder() {
            if (null != orderedSizes) {
                return orderedSizes;
            }
            List<Size> orderedSizes = Arrays.asList(Size.values());
            Collections.sort(orderedSizes, new Comparator<Size>(){

                @Override
                public int compare(Size o1, Size o2) {
                    if (o1.getPixels() == o2.getPixels()) {
                        return 0;
                    }
                    return o1.getPixels() < o2.getPixels() ? -1 : 1;
                }
            });
            return orderedSizes;
        }

        public int getPixels() {
            return this.pixels;
        }

        public String toString() {
            return String.format("<Size [%s], %dx%dpx>", this.param, this.pixels, this.pixels);
        }

        static {
            Size maxValue = SMALL;
            Size defaultValue = SMALL;
            for (Size imageSize : Size.values()) {
                if (imageSize.isDefault) {
                    defaultValue = imageSize;
                }
                if (imageSize.pixels <= maxValue.pixels) continue;
                maxValue = imageSize;
            }
            largest = maxValue;
            defaultSize = defaultValue;
            orderedSizes = Size.inPixelOrder();
        }
    }

    public static enum Type {
        PROJECT("project"),
        USER("user");

        private String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static Type getByName(String name) {
            if (name == null) {
                return null;
            }
            if (PROJECT.getName().equals(name)) {
                return PROJECT;
            }
            if (USER.getName().equals(name)) {
                return USER;
            }
            return null;
        }
    }
}

