/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event;

import com.atlassian.jira.event.JiraEvent;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.Map;

public abstract class AbstractEvent
implements JiraEvent {
    protected Date time = new Date();
    protected Map<String, Object> params;

    public AbstractEvent() {
        this.params = Maps.newHashMap();
    }

    public AbstractEvent(Map<String, Object> params) {
        this.params = params != null ? params : Maps.newHashMap();
    }

    @Override
    public Date getTime() {
        return this.time;
    }

    @Override
    public Map<String, Object> getParams() {
        return this.params;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractEvent)) {
            return false;
        }
        AbstractEvent event = (AbstractEvent)o;
        if (this.params != null ? !this.params.equals(event.params) : event.params != null) {
            return false;
        }
        return !(this.time != null ? !this.time.equals(event.time) : event.time != null);
    }

    public int hashCode() {
        int result = this.time != null ? this.time.hashCode() : 0;
        result = 29 * result + (this.params != null ? this.params.hashCode() : 0);
        return result;
    }
}

