/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.search.ReaderCache;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.statistics.FilterStatisticsValuesGenerator;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.issue.statistics.util.OneDimensionalTermHitCollector;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugin.util.TabPanelUtil;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.web.bean.StatisticMapWrapper;
import com.atlassian.query.clause.Clause;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.ofbiz.core.entity.GenericValue;

public class StatisticAccessorBean {
    private User remoteUser;
    private SearchRequest filter;
    private final boolean overrideSecurity;
    private final SearchProvider searchProvider = ComponentAccessor.getComponent(SearchProvider.class);
    private final FieldVisibilityManager fieldVisibilityManager = ComponentAccessor.getComponent(FieldVisibilityManager.class);
    private final ReaderCache readerCache = ComponentAccessor.getComponent(ReaderCache.class);
    private static final Comparator<Map.Entry<String, Integer>> mapEntryComparator = new Comparator<Map.Entry<String, Integer>>(){

        @Override
        public int compare(Map.Entry<String, Integer> e1, Map.Entry<String, Integer> e2) {
            Integer v2;
            Integer v1 = e1.getValue();
            int result = v1.compareTo(v2 = e2.getValue());
            if (result == 0) {
                String k1 = e1.getKey();
                String k2 = e2.getKey();
                if (k1 == null && k2 == null) {
                    return 0;
                }
                if (k1 == null) {
                    return 1;
                }
                if (k2 == null) {
                    return -1;
                }
                result = k1.compareTo(k2);
            }
            return result;
        }
    };

    public StatisticAccessorBean() {
        this.overrideSecurity = false;
    }

    public StatisticAccessorBean(User remoteUser, SearchRequest filter) {
        this.remoteUser = remoteUser;
        this.filter = filter;
        this.overrideSecurity = false;
    }

    public StatisticAccessorBean(User remoteUser, SearchRequest filter, boolean overrideSecurity) {
        this.remoteUser = remoteUser;
        this.filter = filter;
        this.overrideSecurity = overrideSecurity;
    }

    public StatisticAccessorBean(User remoteUser, Long projectId, boolean limitToOpenIssues) {
        this.remoteUser = remoteUser;
        this.filter = this.getProjectFilter(projectId, limitToOpenIssues);
        this.overrideSecurity = false;
    }

    public StatisticAccessorBean(User remoteUser, Long projectId) {
        this(remoteUser, projectId, true);
    }

    public StatisticAccessorBean(User remoteUser, Long projectId, Clause additionalClause, boolean limitToOpenIssues) {
        this(remoteUser, projectId, limitToOpenIssues);
        if (additionalClause != null) {
            this.addAdditionalParameters(this.filter, additionalClause);
        }
    }

    private SearchRequest getProjectFilter(Long projectId, boolean limitToOpenIssues) {
        JqlClauseBuilder builder = JqlQueryBuilder.newBuilder().where().defaultAnd();
        if (limitToOpenIssues) {
            builder.unresolved();
        }
        builder.project(projectId);
        return new SearchRequest(builder.buildQuery());
    }

    private void addAdditionalParameters(SearchRequest sr, Clause additionalClause) {
        JqlQueryBuilder query = JqlQueryBuilder.newBuilder(sr.getQuery());
        query.where().defaultAnd().addClause(additionalClause);
        sr.setQuery(query.buildQuery());
    }

    public SearchRequest getFilter() {
        return this.filter;
    }

    public StatisticMapWrapper getWrapper(StatisticsMapper mapper) throws SearchException {
        return this.getWrapper(mapper, null, null);
    }

    public StatisticMapWrapper getWrapper(StatisticsMapper mapper, OrderBy orderBy, Direction direction) throws SearchException {
        Set<Map.Entry<String, Integer>> mapEntrySet;
        AbstractMap map;
        SearchStatisticsResult statisticsResult = this.searchCountMap(mapper.getDocumentConstant());
        Map<String, Integer> groupedCounts = statisticsResult.getStatistics();
        long numberOfissues = statisticsResult.getNumberOfIssues();
        if (orderBy != null && OrderBy.TOTAL.equals(orderBy)) {
            map = new LinkedHashMap();
            mapEntrySet = new TreeSet<Map.Entry<String, Integer>>(this.getDirectionalComparator(mapEntryComparator, direction));
            mapEntrySet.addAll(groupedCounts.entrySet());
        } else {
            Comparator c = mapper.getComparator();
            map = c != null ? new TreeMap(this.getDirectionalComparator(c, direction)) : new HashMap();
            mapEntrySet = groupedCounts.entrySet();
        }
        for (Map.Entry<String, Integer> entry : mapEntrySet) {
            String fieldValue = entry.getKey();
            Object objectValue = mapper.getValueFromLuceneField(fieldValue);
            if (!mapper.isValidValue(objectValue)) continue;
            map.put(objectValue, entry.getValue());
        }
        return new StatisticMapWrapper(map, numberOfissues, statisticsResult.getNumberOfIrrelevantResults());
    }

    private <T> Comparator<T> getDirectionalComparator(Comparator<T> c, Direction direction) {
        if (direction != null && Direction.DESC.equals(direction)) {
            return new ReverseComparator(c);
        }
        return c;
    }

    protected SearchStatisticsResult searchCountMap(String groupField) throws SearchException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        OneDimensionalTermHitCollector hitCollector = new OneDimensionalTermHitCollector(groupField, result, this.fieldVisibilityManager, this.readerCache);
        if (this.overrideSecurity) {
            this.searchProvider.searchOverrideSecurity(this.filter.getQuery(), this.remoteUser, hitCollector);
        } else {
            this.searchProvider.search(this.filter.getQuery(), this.remoteUser, hitCollector);
        }
        return new SearchStatisticsResult(hitCollector.getHitCount(), hitCollector.getIrrelevantCount(), result);
    }

    public long getOpenByComponent() throws SearchException {
        return this.getOpenByComponent(null);
    }

    public long getOpenByComponent(GenericValue component) throws SearchException {
        if (component != null) {
            return this.getCountWithClause(JqlQueryBuilder.newClauseBuilder().component(component.getLong("id")).buildClause());
        }
        return this.getCountWithClause(JqlQueryBuilder.newClauseBuilder().componentIsEmpty().buildClause());
    }

    public long getOpenByFixFor() throws SearchException {
        return this.getOpenByFixFor(null);
    }

    public long getOpenByFixFor(Version version) throws SearchException {
        if (version != null) {
            return this.getCountWithClause(JqlQueryBuilder.newClauseBuilder().fixVersion(version.getId()).buildClause());
        }
        return this.getCountWithClause(JqlQueryBuilder.newClauseBuilder().fixVersionIsEmpty().buildClause());
    }

    public long getCount() throws SearchException {
        if (this.overrideSecurity) {
            return this.searchProvider.searchCountOverrideSecurity(this.filter.getQuery(), this.remoteUser);
        }
        return this.searchProvider.searchCount(this.filter.getQuery(), this.remoteUser);
    }

    public Collection getIssues() throws SearchException {
        if (this.overrideSecurity) {
            return this.searchProvider.searchOverrideSecurity(this.filter.getQuery(), this.remoteUser, TabPanelUtil.PAGER_FILTER, null).getIssues();
        }
        return this.searchProvider.search(this.filter.getQuery(), this.remoteUser, TabPanelUtil.PAGER_FILTER).getIssues();
    }

    private long getCountWithClause(Clause clause) throws SearchException {
        JqlQueryBuilder builder = JqlQueryBuilder.newBuilder(this.filter.getQuery());
        JqlClauseBuilder whereClauseBuilder = builder.where().defaultAnd();
        whereClauseBuilder.addClause(clause);
        if (this.overrideSecurity) {
            return this.searchProvider.searchCountOverrideSecurity(whereClauseBuilder.buildQuery(), this.remoteUser);
        }
        return this.searchProvider.searchCount(whereClauseBuilder.buildQuery(), this.remoteUser);
    }

    public StatisticMapWrapper getAllFilterBy(String type) throws SearchException {
        return this.getWrapper(this.getMapper(type));
    }

    public StatisticMapWrapper getAllFilterBy(String type, OrderBy orderBy, Direction direction) throws SearchException {
        return this.getWrapper(this.getMapper(type), orderBy, direction);
    }

    public StatisticsMapper getMapper(String type) {
        return new FilterStatisticsValuesGenerator().getStatsMapper(type);
    }

    public static class Direction {
        public static final Direction ASC = new Direction("asc");
        public static final Direction DESC = new Direction("desc");
        private final String description;

        public static Direction get(String direction) {
            return Direction.DESC.description.equals(direction) ? DESC : ASC;
        }

        private Direction(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }

    public static class OrderBy {
        public static final OrderBy TOTAL = new OrderBy("total");
        public static final OrderBy NATURAL = new OrderBy("natural");
        private final String description;

        public static OrderBy get(String orderBy) {
            return OrderBy.TOTAL.description.equals(orderBy) ? TOTAL : NATURAL;
        }

        private OrderBy(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }

    private static class SearchStatisticsResult {
        private final long numberOfIssues;
        private final long numberOfIrrelevantResults;
        private final Map<String, Integer> statistics;

        public SearchStatisticsResult(long numberOfIssues, long numberOfIrrelevantResults, Map<String, Integer> statistics) {
            this.numberOfIssues = numberOfIssues;
            this.numberOfIrrelevantResults = numberOfIrrelevantResults;
            this.statistics = statistics;
        }

        public long getNumberOfIssues() {
            return this.numberOfIssues;
        }

        public long getNumberOfIrrelevantResults() {
            return this.numberOfIrrelevantResults;
        }

        public Map<String, Integer> getStatistics() {
            return this.statistics;
        }
    }
}

