/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.services.mail;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.service.util.handler.MessageHandlerExecutionMonitor;
import com.google.common.collect.Lists;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Queue;
import javax.annotation.Nullable;
import javax.mail.Message;
import org.apache.commons.lang.StringUtils;

@Internal
class ErrorAccumulatingMessageHandlerExecutionMonitor
implements MessageHandlerExecutionMonitor {
    private final MessageHandlerExecutionMonitor delgate;
    private volatile boolean hasErrors = false;
    private final Queue<String> errors = Lists.newLinkedList();
    private String lastReportedExceptionStackTrace;

    public ErrorAccumulatingMessageHandlerExecutionMonitor(MessageHandlerExecutionMonitor delgate) {
        this.delgate = delgate;
    }

    @Override
    public void setNumMessages(int count) {
        this.delgate.setNumMessages(count);
    }

    @Override
    public void messageRejected(Message message, String reason) {
        this.delgate.messageRejected(message, reason);
    }

    @Override
    public void nextMessage(Message message) {
        this.delgate.nextMessage(message);
    }

    @Override
    public void error(String error) {
        this.delgate.error(error);
        this.addErrorImpl(error);
    }

    @Override
    public void warning(String warning) {
        this.delgate.warning(warning);
        this.addErrorImpl(warning);
    }

    @Override
    public void warning(String warning, @Nullable Throwable e) {
        this.delgate.warning(warning, e);
        this.addErrorImpl(warning);
    }

    @Override
    public void info(String info) {
        this.delgate.info(info);
    }

    @Override
    public void info(String info, @Nullable Throwable e) {
        this.delgate.info(info, e);
    }

    private synchronized void addErrorImpl(String error) {
        this.hasErrors = true;
        if (error != null) {
            if (this.errors.size() > 5) {
                this.errors.remove();
            }
            this.errors.add(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void error(String error, @Nullable Throwable e) {
        this.delgate.error(error, e);
        this.addErrorImpl(error);
        if (e != null) {
            ErrorAccumulatingMessageHandlerExecutionMonitor errorAccumulatingMessageHandlerExecutionMonitor = this;
            synchronized (errorAccumulatingMessageHandlerExecutionMonitor) {
                this.lastReportedExceptionStackTrace = this.getStackTraceAsString(e);
            }
        }
        ErrorAccumulatingMessageHandlerExecutionMonitor errorAccumulatingMessageHandlerExecutionMonitor = this;
        synchronized (errorAccumulatingMessageHandlerExecutionMonitor) {
            this.lastReportedExceptionStackTrace = null;
        }
    }

    public synchronized boolean hasErrors() {
        return this.hasErrors;
    }

    public synchronized String getErrorsAsString() {
        return StringUtils.join(this.errors, (String)"\n");
    }

    public synchronized String getExceptionsAsString() {
        return this.lastReportedExceptionStackTrace;
    }

    String getStackTraceAsString(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter p = new PrintWriter(stringWriter);
        e.printStackTrace(p);
        p.flush();
        p.close();
        return stringWriter.toString();
    }
}

