/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail.settings;

import com.atlassian.annotations.Internal;
import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.google.common.annotations.VisibleForTesting;

@PublicApi
public interface MailSettings {
    public Send send();

    public Fetch fetch();

    public static class Fetch {
        @VisibleForTesting
        static final String DISABLED_APPLICATION_PROPERTY = "jira.mail.fetch.disabled";
        @VisibleForTesting
        static final String LEGACY_DISABLED_SYSTEM_PROPERTY = "atlassian.mail.popdisabled";
        @VisibleForTesting
        static final String DISABLED_SYSTEM_PROPERTY = "atlassian.mail.fetchdisabled";
        private final ApplicationProperties applicationProperties;

        public Fetch(ApplicationProperties applicationProperties) {
            this.applicationProperties = applicationProperties;
        }

        public boolean isEnabled() {
            return !this.isDisabled();
        }

        private boolean getSystemPropertyValue() {
            return Boolean.getBoolean(LEGACY_DISABLED_SYSTEM_PROPERTY) || Boolean.getBoolean(DISABLED_SYSTEM_PROPERTY);
        }

        public boolean isDisabled() {
            if (this.getSystemPropertyValue()) {
                return true;
            }
            return this.applicationProperties.getOption(DISABLED_APPLICATION_PROPERTY);
        }

        public boolean isModifiable() {
            return !this.getSystemPropertyValue();
        }

        public boolean enable() {
            if (!this.isModifiable()) {
                return false;
            }
            this.applicationProperties.setOption(DISABLED_APPLICATION_PROPERTY, false);
            return true;
        }

        public boolean disable() {
            if (!this.isModifiable()) {
                return false;
            }
            this.applicationProperties.setOption(DISABLED_APPLICATION_PROPERTY, true);
            return true;
        }
    }

    public static class Send {
        @VisibleForTesting
        static final String DISABLED_APPLICATION_PROPERTY = "jira.mail.send.disabled";
        @VisibleForTesting
        static final String DISABLED_SYSTEM_PROPERTY_KEY = "atlassian.mail.senddisabled";
        private final ApplicationProperties applicationProperties;

        private Send(ApplicationProperties applicationProperties) {
            this.applicationProperties = applicationProperties;
        }

        public boolean isEnabled() {
            return !this.isDisabled();
        }

        public boolean isDisabled() {
            if (Boolean.getBoolean(DISABLED_SYSTEM_PROPERTY_KEY)) {
                return true;
            }
            return this.applicationProperties.getOption(DISABLED_APPLICATION_PROPERTY);
        }

        public boolean isModifiable() {
            return !Boolean.getBoolean(DISABLED_SYSTEM_PROPERTY_KEY);
        }

        public boolean enable() {
            if (!this.isModifiable()) {
                return false;
            }
            this.applicationProperties.setOption(DISABLED_APPLICATION_PROPERTY, false);
            return true;
        }

        public boolean disable() {
            if (!this.isModifiable()) {
                return false;
            }
            this.applicationProperties.setOption(DISABLED_APPLICATION_PROPERTY, true);
            return true;
        }
    }

    @Internal
    public static class DefaultMailSettings
    implements MailSettings {
        private final Send send;
        private final Fetch fetch;

        public DefaultMailSettings(ApplicationProperties applicationProperties) {
            this.send = new Send(applicationProperties);
            this.fetch = new Fetch(applicationProperties);
        }

        @Override
        public Send send() {
            return this.send;
        }

        @Override
        public Fetch fetch() {
            return this.fetch;
        }
    }
}

