/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.parameters.lucene.sort;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.issue.search.parameters.lucene.sort.DefaultMatchHandler;
import com.atlassian.jira.issue.search.parameters.lucene.sort.MappedSortComparator;
import com.atlassian.jira.issue.search.parameters.lucene.sort.MatchHandler;
import com.atlassian.jira.issue.search.parameters.lucene.sort.SingleValueMatchHandler;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;

public class JiraLuceneFieldFinder {
    private static final JiraLuceneFieldFinder FIELD_FINDER = new JiraLuceneFieldFinder();

    public static JiraLuceneFieldFinder getInstance() {
        return FIELD_FINDER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getCustom(IndexReader reader, String field, MappedSortComparator mappedSortComparator) throws IOException {
        String internedField = field.intern();
        Object[] retArray = new Object[reader.maxDoc()];
        if (retArray.length > 0) {
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(internedField, ""));
            try {
                if (termEnum.term() == null) {
                    Object[] objectArray = retArray;
                    return objectArray;
                }
                Comparator comparator = mappedSortComparator.getComparator();
                do {
                    Term term;
                    if ((term = termEnum.term()).field() != internedField) {
                        break;
                    }
                    Object termval = mappedSortComparator.getComparable(term.text());
                    termDocs.seek(termEnum);
                    while (termDocs.next()) {
                        Object currentValue = retArray[termDocs.doc()];
                        if (currentValue != null && comparator.compare(termval, currentValue) >= 1) continue;
                        retArray[termDocs.doc()] = termval;
                    }
                } while (termEnum.next());
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
        }
        return retArray;
    }

    public Collection<String>[] getMatches(IndexReader reader, String field) throws IOException {
        int maxDoc = reader.maxDoc();
        DefaultMatchHandler handler = new DefaultMatchHandler(maxDoc);
        this.getMatches(reader, field, handler);
        return handler.getResults();
    }

    @ExperimentalApi
    public List<String>[] getUniqueMatches(IndexReader reader, String field) throws IOException {
        int maxDoc = reader.maxDoc();
        SingleValueMatchHandler handler = new SingleValueMatchHandler(maxDoc);
        this.getMatches(reader, field, handler);
        return handler.getResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExperimentalApi
    public void getMatches(IndexReader reader, String field, MatchHandler handler) throws IOException {
        if (reader.maxDoc() == 0) {
            return;
        }
        String internedField = field.intern();
        TermDocs termDocs = reader.termDocs();
        try {
            TermEnum termEnum = reader.terms(new Term(internedField, ""));
            try {
                if (termEnum.term() == null) {
                    throw new RuntimeException("no terms in field " + field);
                }
                do {
                    Term term;
                    if ((term = termEnum.term()).field() != internedField) {
                        break;
                    }
                    String termval = term.text();
                    termDocs.seek(termEnum);
                    while (termDocs.next()) {
                        handler.handleMatchedDocument(termDocs.doc(), termval);
                    }
                } while (termEnum.next());
            }
            finally {
                termEnum.close();
            }
        }
        finally {
            termDocs.close();
        }
    }
}

