/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.util.JiraUrlCodec;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PriorityJsonBean {
    @JsonProperty
    private String self;
    @JsonProperty
    private String statusColor;
    @JsonProperty
    private String description;
    @JsonProperty
    private String iconUrl;
    @JsonProperty
    private String name;
    @JsonProperty
    private String id;

    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public String getStatusColor() {
        return this.statusColor;
    }

    public void setStatusColor(String statusColor) {
        this.statusColor = statusColor;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public static PriorityJsonBean shortBean(Priority priority, JiraBaseUrls urls) {
        String iconAbsoluteUrl;
        if (priority == null) {
            return null;
        }
        try {
            iconAbsoluteUrl = new URL(priority.getIconUrl()).toString();
        }
        catch (MalformedURLException e) {
            iconAbsoluteUrl = urls.baseUrl() + priority.getIconUrl();
        }
        PriorityJsonBean bean = new PriorityJsonBean();
        bean.self = urls.restApi2BaseUrl() + "priority/" + JiraUrlCodec.encode(priority.getId());
        bean.name = priority.getNameTranslation();
        bean.id = priority.getId();
        bean.iconUrl = iconAbsoluteUrl;
        return bean;
    }

    public static PriorityJsonBean fullBean(Priority priority, JiraBaseUrls urls) {
        if (priority == null) {
            return null;
        }
        PriorityJsonBean bean = PriorityJsonBean.shortBean(priority, urls);
        bean.statusColor = priority.getStatusColor();
        bean.description = priority.getDescTranslation();
        return bean;
    }

    public static Collection<PriorityJsonBean> shortBeans(Collection<Priority> allowedValues, final JiraBaseUrls baseUrls) {
        return Collections2.transform(allowedValues, (Function)new Function<Priority, PriorityJsonBean>(){

            public PriorityJsonBean apply(Priority from) {
                return PriorityJsonBean.shortBean(from, baseUrls);
            }
        });
    }
}

