/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.util.JiraUrlCodec;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ComponentJsonBean {
    @JsonProperty
    private String self;
    @JsonProperty
    private String id;
    @JsonProperty
    private String name;
    @JsonProperty
    private String description;

    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static Collection<ComponentJsonBean> shortBeans(Collection<ProjectComponent> components, final JiraBaseUrls urls) {
        return Collections2.transform(components, (Function)new Function<ProjectComponent, ComponentJsonBean>(){

            public ComponentJsonBean apply(ProjectComponent from) {
                return ComponentJsonBean.shortBean(from, urls);
            }
        });
    }

    public static ComponentJsonBean shortBean(ProjectComponent component, JiraBaseUrls urls) {
        if (component == null) {
            return null;
        }
        ComponentJsonBean bean = new ComponentJsonBean();
        bean.self = urls.restApi2BaseUrl() + "component/" + JiraUrlCodec.encode(component.getId().toString());
        bean.id = component.getId().toString();
        bean.description = component.getDescription();
        bean.name = component.getName();
        return bean;
    }
}

