/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.security.login;

import com.atlassian.annotations.PublicApi;

@PublicApi
public final class LoginProperties {
    private final boolean allowCookies;
    private final boolean externalPasswordManagement;
    private final boolean externalUserManagement;
    private final boolean isPublicMode;
    private final boolean isElevatedSecurityCheckShown;
    private final boolean loginSucceeded;
    private final boolean loginError;
    private final boolean communicationError;
    private final boolean captchaFailure;
    private final boolean loginFailedByPermissions;
    private final String contactAdminLink;

    private LoginProperties(boolean loginSucceeded, boolean loginError, boolean communicationError, boolean allowCookies, boolean externalPasswordManagement, boolean externalUserManagement, boolean publicMode, boolean isElevatedSecurityCheckShown, boolean captchaFailure, boolean loginFailedByPermssions, String contactAdminLink) {
        this.loginSucceeded = loginSucceeded;
        this.loginError = loginError;
        this.communicationError = communicationError;
        this.allowCookies = allowCookies;
        this.externalPasswordManagement = externalPasswordManagement;
        this.externalUserManagement = externalUserManagement;
        this.isPublicMode = publicMode;
        this.isElevatedSecurityCheckShown = isElevatedSecurityCheckShown;
        this.captchaFailure = captchaFailure;
        this.loginFailedByPermissions = loginFailedByPermssions;
        this.contactAdminLink = contactAdminLink;
    }

    public boolean isLoginSucceeded() {
        return this.loginSucceeded;
    }

    public boolean isLoginError() {
        return this.loginError;
    }

    public boolean isCommunicationError() {
        return this.communicationError;
    }

    public boolean isAllowCookies() {
        return this.allowCookies;
    }

    public boolean isExternalPasswordManagement() {
        return this.externalPasswordManagement;
    }

    public boolean isExternalUserManagement() {
        return this.externalUserManagement;
    }

    public boolean isPublicMode() {
        return this.isPublicMode;
    }

    public boolean isElevatedSecurityCheckShown() {
        return this.isElevatedSecurityCheckShown;
    }

    public boolean isCaptchaFailure() {
        return this.captchaFailure;
    }

    public boolean getLoginFailedByPermissions() {
        return this.loginFailedByPermissions;
    }

    public String getContactAdminLink() {
        return this.contactAdminLink;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean allowCookies;
        private boolean externalPasswordManagement;
        private boolean externalUserManagement;
        private boolean isPublicMode;
        private boolean isElevatedSecurityCheckShown;
        private boolean loginSucceeded;
        private boolean captchaFailure;
        private boolean loginFailedByPermissions;
        private boolean loginError;
        private boolean communicationError;
        private String contactAdminLink;

        public Builder allowCookies(boolean allowCookies) {
            this.allowCookies = allowCookies;
            return this;
        }

        public Builder externalPasswordManagement(boolean externalPasswordManagement) {
            this.externalPasswordManagement = externalPasswordManagement;
            return this;
        }

        public Builder externalUserManagement(boolean externalUserManagement) {
            this.externalUserManagement = externalUserManagement;
            return this;
        }

        public Builder isPublicMode(boolean isPublicMode) {
            this.isPublicMode = isPublicMode;
            return this;
        }

        public Builder isElevatedSecurityCheckShown(boolean isElevatedSecurityCheckShown) {
            this.isElevatedSecurityCheckShown = isElevatedSecurityCheckShown;
            return this;
        }

        public Builder loginSucceeded(boolean loginSucceeded) {
            this.loginSucceeded = loginSucceeded;
            return this;
        }

        public Builder captchaFailure(boolean captchaFailure) {
            this.captchaFailure = captchaFailure;
            return this;
        }

        public Builder loginFailedByPermissions(boolean loginFailedByPermissions) {
            this.loginFailedByPermissions = loginFailedByPermissions;
            return this;
        }

        public Builder loginError(boolean loginError) {
            this.loginError = loginError;
            return this;
        }

        public Builder communicationError(boolean communicationError) {
            this.communicationError = communicationError;
            return this;
        }

        public Builder contactAdminLink(String contactAdminLink) {
            this.contactAdminLink = contactAdminLink;
            return this;
        }

        public LoginProperties build() {
            return new LoginProperties(this.loginSucceeded, this.loginError, this.communicationError, this.allowCookies, this.externalPasswordManagement, this.externalUserManagement, this.isPublicMode, this.isElevatedSecurityCheckShown, this.captchaFailure, this.loginFailedByPermissions, this.contactAdminLink);
        }
    }
}

