/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.link;

import com.atlassian.annotations.PublicApi;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.link.Direction;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.LinkCollection;
import com.atlassian.jira.util.ErrorCollection;
import java.util.Collection;

@PublicApi
public interface IssueLinkService {
    public Collection<IssueLinkType> getIssueLinkTypes();

    public IssueLink getIssueLink(Long var1, Long var2, Long var3);

    public SingleIssueLinkResult getIssueLink(Long var1, User var2);

    public IssueLinkResult getIssueLinks(User var1, Issue var2);

    public IssueLinkResult getIssueLinks(User var1, Issue var2, boolean var3);

    public AddIssueLinkValidationResult validateAddIssueLinks(User var1, Issue var2, String var3, Collection<String> var4);

    public AddIssueLinkValidationResult validateAddIssueLinks(User var1, Issue var2, Long var3, Direction var4, Collection<String> var5, boolean var6);

    public void addIssueLinks(User var1, AddIssueLinkValidationResult var2);

    public DeleteIssueLinkValidationResult validateDelete(User var1, Issue var2, IssueLink var3);

    public void delete(DeleteIssueLinkValidationResult var1);

    @PublicApi
    public static class DeleteIssueLinkValidationResult
    extends ServiceResultImpl {
        private final IssueLink issueLink;
        private final User user;

        DeleteIssueLinkValidationResult(ErrorCollection errorCollection, IssueLink issueLink, User user) {
            super(errorCollection);
            this.issueLink = issueLink;
            this.user = user;
        }

        public IssueLink getIssueLink() {
            return this.issueLink;
        }

        public User getUser() {
            return this.user;
        }
    }

    @PublicApi
    public static class AddIssueLinkValidationResult
    extends IssueLinkValidationResult {
        private final User user;
        private final Collection<String> linkKeys;
        private IssueLinkType linkType;
        private Direction direction;

        public AddIssueLinkValidationResult(User user, ErrorCollection errorCollection, Issue issueId, IssueLinkType linkType, Direction direction, Collection<String> linkKeys) {
            super(errorCollection, issueId);
            this.user = user;
            this.linkType = linkType;
            this.direction = direction;
            this.linkKeys = linkKeys;
        }

        public Collection<String> getLinkKeys() {
            return this.linkKeys;
        }

        public String getLinkName() {
            return this.direction == Direction.OUT ? this.linkType.getOutward() : this.linkType.getInward();
        }

        public IssueLinkType getLinkType() {
            return this.linkType;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public User getUser() {
            return this.user;
        }
    }

    public static abstract class IssueLinkValidationResult
    extends ServiceResultImpl {
        private final Issue issue;

        public IssueLinkValidationResult(ErrorCollection errorCollection, Issue issueId) {
            super(errorCollection);
            this.issue = issueId;
        }

        public Issue getIssue() {
            return this.issue;
        }
    }

    @PublicApi
    public static class SingleIssueLinkResult
    extends ServiceResultImpl {
        private final IssueLink issueLink;

        public SingleIssueLinkResult(ErrorCollection errorCollection, IssueLink issueLink) {
            super(errorCollection);
            this.issueLink = issueLink;
        }

        public IssueLink getIssueLink() {
            return this.issueLink;
        }
    }

    @PublicApi
    public static class IssueLinkResult
    extends ServiceResultImpl {
        private final LinkCollection linkCollection;

        public IssueLinkResult(ErrorCollection errorCollection, LinkCollection linkCollection) {
            super(errorCollection);
            this.linkCollection = linkCollection;
        }

        public LinkCollection getLinkCollection() {
            return this.linkCollection;
        }
    }
}

