/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics;

import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.util.LuceneUtils;
import java.util.Comparator;
import java.util.Date;
import java.util.TimeZone;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriod;

public class DatePeriodStatisticsMapper
implements StatisticsMapper<TimePeriod> {
    private final Class timePeriodClass;
    private final TimeZone periodTimeZone;
    private final String documentConstant;

    public DatePeriodStatisticsMapper(Class timePeriodClass, String documentConstant, TimeZone periodTimeZone) {
        this.documentConstant = documentConstant;
        this.timePeriodClass = timePeriodClass;
        this.periodTimeZone = periodTimeZone;
    }

    @Override
    public SearchRequest getSearchUrlSuffix(TimePeriod value, SearchRequest searchRequest) {
        TimePeriod timePeriod = value;
        Date startDate = timePeriod.getStart();
        Date endDate = new Date(timePeriod.getEnd().getTime());
        JqlQueryBuilder builder = JqlQueryBuilder.newBuilder(searchRequest.getQuery());
        builder.where().defaultAnd().addDateRangeCondition(this.documentConstant, startDate, endDate);
        return new SearchRequest(builder.buildQuery(), searchRequest.getOwnerUserName(), null, null);
    }

    @Override
    public String getDocumentConstant() {
        return this.documentConstant;
    }

    @Override
    public TimePeriod getValueFromLuceneField(String documentValue) {
        Date date = LuceneUtils.stringToDate(documentValue);
        if (date == null) {
            return null;
        }
        return RegularTimePeriod.createInstance((Class)this.timePeriodClass, (Date)date, (TimeZone)this.periodTimeZone);
    }

    @Override
    public Comparator<TimePeriod> getComparator() {
        return new Comparator<TimePeriod>(){

            @Override
            public int compare(TimePeriod timePeriod1, TimePeriod timePeriod2) {
                if (timePeriod1 == null) {
                    return -1;
                }
                return timePeriod1.compareTo((Object)timePeriod2);
            }
        };
    }

    @Override
    public boolean isValidValue(TimePeriod value) {
        return value != null;
    }

    @Override
    public boolean isFieldAlwaysPartOfAnIssue() {
        return true;
    }
}

