/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user;

import com.atlassian.annotations.PublicApi;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import javax.annotation.Nullable;

@PublicApi
public interface UserService {
    public CreateUserValidationResult validateCreateUserForSignup(User var1, String var2, String var3, String var4, String var5, String var6);

    public CreateUserValidationResult validateCreateUserForSetup(User var1, String var2, String var3, String var4, String var5, String var6);

    public CreateUserValidationResult validateCreateUserForSignupOrSetup(User var1, String var2, String var3, String var4, String var5, String var6);

    public CreateUserValidationResult validateCreateUserForAdminPasswordRequired(User var1, String var2, String var3, String var4, String var5, String var6);

    public CreateUserValidationResult validateCreateUserForAdmin(User var1, String var2, String var3, String var4, String var5, String var6);

    public CreateUserValidationResult validateCreateUserForAdmin(User var1, String var2, String var3, String var4, String var5, String var6, @Nullable Long var7);

    public CreateUsernameValidationResult validateCreateUsername(User var1, String var2);

    public CreateUsernameValidationResult validateCreateUsername(User var1, String var2, Long var3);

    public User createUserFromSignup(CreateUserValidationResult var1) throws PermissionException, CreateException;

    public User createUserWithNotification(CreateUserValidationResult var1) throws PermissionException, CreateException;

    public User createUserNoNotification(CreateUserValidationResult var1) throws PermissionException, CreateException;

    public UpdateUserValidationResult validateUpdateUser(User var1);

    public void updateUser(UpdateUserValidationResult var1);

    public DeleteUserValidationResult validateDeleteUser(User var1, String var2);

    public void removeUser(User var1, DeleteUserValidationResult var2);

    @PublicApi
    public static final class FieldName {
        static String EMAIL = "email";
        static String NAME = "username";
        static String FULLNAME = "fullname";
        static String PASSWORD = "password";
        static String CONFIRM_PASSWORD = "confirm";

        private FieldName() {
        }
    }

    @PublicApi
    public static final class DeleteUserValidationResult
    extends ServiceResultImpl {
        private final User user;

        DeleteUserValidationResult(ErrorCollection errorCollection) {
            super(errorCollection);
            this.user = null;
        }

        DeleteUserValidationResult(User user) {
            super(new SimpleErrorCollection());
            this.user = user;
        }

        public User getUser() {
            return this.user;
        }
    }

    @PublicApi
    public static final class UpdateUserValidationResult
    extends ServiceResultImpl {
        private final User user;

        UpdateUserValidationResult(ErrorCollection errorCollection) {
            super(errorCollection);
            this.user = null;
        }

        UpdateUserValidationResult(User user) {
            super(new SimpleErrorCollection());
            this.user = user;
        }

        public User getUser() {
            return this.user;
        }
    }

    @PublicApi
    public static final class CreateUsernameValidationResult
    extends ServiceResultImpl {
        private final String username;
        private final Long directoryId;

        public CreateUsernameValidationResult(String username, Long directoryId, ErrorCollection errorCollection) {
            super(errorCollection);
            this.username = username;
            this.directoryId = directoryId;
        }

        public String getUsername() {
            return this.username;
        }

        public Long getDirectoryId() {
            return this.directoryId;
        }
    }

    @PublicApi
    public static final class CreateUserValidationResult
    extends ServiceResultImpl {
        private final String username;
        private final String password;
        private final String email;
        private final String fullname;
        private final Long directoryId;

        CreateUserValidationResult(ErrorCollection errorCollection) {
            super(errorCollection);
            this.username = null;
            this.password = null;
            this.email = null;
            this.fullname = null;
            this.directoryId = null;
        }

        CreateUserValidationResult(String username, String password, String email, String fullname) {
            super(new SimpleErrorCollection());
            this.username = username;
            this.password = password;
            this.email = email;
            this.fullname = fullname;
            this.directoryId = null;
        }

        CreateUserValidationResult(String username, String password, String email, String fullname, Long directoryId) {
            super(new SimpleErrorCollection());
            this.username = username;
            this.password = password;
            this.email = email;
            this.fullname = fullname;
            this.directoryId = directoryId;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getEmail() {
            return this.email;
        }

        public String getFullname() {
            return this.fullname;
        }

        public Long getDirectoryId() {
            return this.directoryId;
        }
    }
}

