/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.worklog;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.issue.worklog.WorklogManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.util.JiraDateUtils;
import java.util.Date;

public class WorklogImpl
implements Worklog {
    private final WorklogManager worklogManager;
    private final Long id;
    private final String author;
    private final String updateAuthor;
    private final String comment;
    private final String groupLevel;
    private final Long roleLevelId;
    private final Date created;
    private final Date updated;
    private final Date startDate;
    private final Long timeSpent;
    private final Issue issue;

    public WorklogImpl(WorklogManager worklogManager, Issue issue, Long id, String author, String comment, Date startDate, String groupLevel, Long roleLevelId, Long timeSpent) {
        if (timeSpent == null) {
            throw new IllegalArgumentException("timeSpent must be set!");
        }
        this.worklogManager = worklogManager;
        this.author = author;
        this.updateAuthor = author;
        this.comment = comment;
        this.groupLevel = groupLevel;
        this.roleLevelId = roleLevelId;
        this.timeSpent = timeSpent;
        Date createDate = new Date();
        this.startDate = startDate == null ? createDate : startDate;
        this.created = createDate;
        this.updated = createDate;
        this.issue = issue;
        this.id = id;
    }

    public WorklogImpl(WorklogManager worklogManager, Issue issue, Long id, String author, String comment, Date startDate, String groupLevel, Long roleLevelId, Long timeSpent, String updateAuthor, Date created, Date updated) {
        if (timeSpent == null) {
            throw new IllegalArgumentException("timeSpent must be set!");
        }
        this.worklogManager = worklogManager;
        this.author = author;
        if (updateAuthor == null) {
            updateAuthor = this.author;
        }
        this.updateAuthor = updateAuthor;
        this.comment = comment;
        this.groupLevel = groupLevel;
        this.roleLevelId = roleLevelId;
        this.timeSpent = timeSpent;
        Date createdDate = JiraDateUtils.copyOrCreateDateNullsafe(created);
        this.startDate = startDate == null ? createdDate : startDate;
        this.created = createdDate;
        this.updated = updated == null ? createdDate : updated;
        this.issue = issue;
        this.id = id;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public String getAuthorFullName() {
        return this.getUserFullName(this.getAuthor());
    }

    @Override
    public String getUpdateAuthor() {
        return this.updateAuthor;
    }

    @Override
    public String getUpdateAuthorFullName() {
        return this.getUserFullName(this.getUpdateAuthor());
    }

    @Override
    public Date getStartDate() {
        return JiraDateUtils.copyDateNullsafe(this.startDate);
    }

    @Override
    public Long getTimeSpent() {
        return this.timeSpent;
    }

    @Override
    public String getGroupLevel() {
        return this.groupLevel;
    }

    @Override
    public Long getRoleLevelId() {
        return this.roleLevelId;
    }

    @Override
    public ProjectRole getRoleLevel() {
        return this.roleLevelId == null ? null : this.worklogManager.getProjectRole(this.roleLevelId);
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    @Override
    public Date getUpdated() {
        return this.updated;
    }

    @Override
    public Issue getIssue() {
        return this.issue;
    }

    private String getUserFullName(String username) {
        String fullName = null;
        if (username != null) {
            fullName = UserUtils.getUserEvenWhenUnknown(username).getDisplayName();
        }
        return fullName;
    }
}

