/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts.jfreechart;

import com.atlassian.jira.charts.jfreechart.ChartGenerator;
import com.atlassian.jira.charts.jfreechart.ChartHelper;
import com.atlassian.jira.charts.jfreechart.util.ChartDefaults;
import com.atlassian.jira.charts.jfreechart.util.ChartUtil;
import com.atlassian.jira.util.I18nHelper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieToolTipGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.PieDataset;
import org.jfree.util.Rotation;

public class PieChartGenerator
implements ChartGenerator {
    private final PieDataset pieDataset;
    private I18nHelper i18nHelper;

    public PieChartGenerator(PieDataset pieDataset, I18nHelper i18nHelper) {
        this.pieDataset = pieDataset;
        this.i18nHelper = i18nHelper;
    }

    @Override
    public ChartHelper generateChart() {
        boolean legend = false;
        boolean tooltips = false;
        boolean urls = false;
        JFreeChart chart = ChartFactory.createPieChart(null, (PieDataset)this.pieDataset, (boolean)legend, (boolean)tooltips, (boolean)urls);
        PieChartGenerator.setPieChartDefaults(chart, this.pieDataset, this.i18nHelper);
        return new ChartHelper(chart);
    }

    private static void setPieChartDefaults(JFreeChart chart, PieDataset dataset, I18nHelper i18nHelper) {
        ChartUtil.setDefaults(chart, i18nHelper);
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint((Paint)Color.WHITE);
        plot.setCircular(true);
        plot.setDirection(Rotation.CLOCKWISE);
        plot.setIgnoreNullValues(true);
        plot.setIgnoreZeroValues(true);
        plot.setStartAngle(290.0);
        plot.setShadowXOffset(0.0);
        plot.setShadowYOffset(0.0);
        plot.setBaseSectionOutlinePaint((Paint)ChartDefaults.outlinePaintColor);
        plot.setBaseSectionOutlineStroke((Stroke)new BasicStroke(2.0f));
        plot.setToolTipGenerator((PieToolTipGenerator)new StandardPieToolTipGenerator("{0} {1} ({2})"));
        for (int j = 0; j < dataset.getItemCount() && j < ChartDefaults.darkColors.length && dataset.getValue(j).intValue() > 0; ++j) {
            plot.setSectionPaint(dataset.getKey(j), (Paint)ChartDefaults.darkColors[j]);
        }
        plot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0} = {1}"));
        plot.setLabelGap(0.04);
        plot.setLabelBackgroundPaint((Paint)Color.WHITE);
        plot.setLabelOutlinePaint((Paint)Color.gray.brighter());
        plot.setLabelShadowPaint((Paint)Color.WHITE);
        plot.setLabelFont(ChartDefaults.defaultFont);
        plot.setLegendLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0} ({1} - {2})"));
        plot.setLegendItemShape((Shape)new Rectangle(0, 0, 10, 10));
    }
}

