/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.mapper;

import com.atlassian.jira.external.beans.ExternalUser;
import com.atlassian.jira.imports.project.mapper.AbstractMapper;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UserMapper
extends AbstractMapper {
    private final Map users;
    private final Set usersInUse;
    private final UserUtil userUtil;
    private final Map userExistsCache;

    public UserMapper(UserUtil userUtil) {
        this.userUtil = userUtil;
        this.users = new HashMap();
        this.usersInUse = new HashSet();
        this.userExistsCache = new HashMap();
    }

    public void registerOldValue(ExternalUser externalUser) {
        Assertions.notNull("externalUser", externalUser);
        super.registerOldValue(externalUser.getName(), externalUser.getName());
        this.users.put(externalUser.getName(), externalUser);
    }

    public ExternalUser getExternalUser(String userName) {
        return (ExternalUser)this.users.get(userName);
    }

    @Override
    public String getMappedId(String oldId) {
        if (this.userExists(oldId)) {
            return oldId;
        }
        return null;
    }

    public void flagUserAsMandatory(String oldUserName) {
        super.flagValueAsRequired(oldUserName);
        this.usersInUse.remove(oldUserName);
    }

    public void flagUserAsInUse(String oldUserName) {
        if (!this.getRequiredOldIds().contains(oldUserName)) {
            this.usersInUse.add(oldUserName);
        }
    }

    public Collection getUnmappedMandatoryUsers() {
        ArrayList<ExternalUser> unmappedUsers = new ArrayList<ExternalUser>();
        for (String userName : this.getRequiredOldIds()) {
            if (this.userExists(userName)) continue;
            ExternalUser user = (ExternalUser)this.users.get(userName);
            if (user == null) {
                user = new ExternalUser(userName, "", "");
            }
            unmappedUsers.add(user);
        }
        return unmappedUsers;
    }

    public List getUnmappedMandatoryUsersWithNoRegisteredOldValue() {
        ArrayList<ExternalUser> unregisteredUsers = new ArrayList<ExternalUser>();
        for (String userName : this.getRequiredOldIds()) {
            ExternalUser user;
            if (this.userExists(userName) || (user = (ExternalUser)this.users.get(userName)) != null) continue;
            unregisteredUsers.add(new ExternalUser(userName, "", ""));
        }
        return unregisteredUsers;
    }

    public List getUnmappedUsersInUseWithNoRegisteredOldValue() {
        ArrayList<ExternalUser> unregisteredUsers = new ArrayList<ExternalUser>();
        for (String userName : this.usersInUse) {
            ExternalUser user;
            if (this.userExists(userName) || (user = (ExternalUser)this.users.get(userName)) != null) continue;
            unregisteredUsers.add(new ExternalUser(userName, "", ""));
        }
        return unregisteredUsers;
    }

    public Collection getUnmappedUsersInUse() {
        ArrayList<ExternalUser> unmappedUsers = new ArrayList<ExternalUser>();
        for (String userName : this.usersInUse) {
            if (this.userExists(userName)) continue;
            ExternalUser user = (ExternalUser)this.users.get(userName);
            if (user == null) {
                user = new ExternalUser(userName, "", "");
            }
            unmappedUsers.add(user);
        }
        return unmappedUsers;
    }

    public Collection getUsersToAutoCreate() {
        ExternalUser user;
        ArrayList<ExternalUser> autoCreatable = new ArrayList<ExternalUser>();
        for (String userName : this.getRequiredOldIds()) {
            if (this.userExists(userName) || (user = (ExternalUser)this.users.get(userName)) == null) continue;
            autoCreatable.add(user);
        }
        for (String userName : this.usersInUse) {
            if (this.userExists(userName) || (user = (ExternalUser)this.users.get(userName)) == null) continue;
            autoCreatable.add(user);
        }
        return autoCreatable;
    }

    public Collection getOptionalOldIds() {
        return this.usersInUse;
    }

    public boolean userExists(String userName) {
        Boolean exists = (Boolean)this.userExistsCache.get(userName);
        if (exists == null) {
            exists = this.userUtil.userExists(userName);
            this.userExistsCache.put(userName, exists);
        }
        return exists;
    }

    @Override
    public void clearMappedValues() {
        super.clearMappedValues();
        this.userExistsCache.clear();
    }
}

