/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers.transformer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.searchers.transformer.AbstractSingleValueCustomFieldSearchInputTransformer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.jql.validator.FreeTextFieldValidator;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operator.Operator;
import org.apache.commons.lang.ClassUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;

public class FreeTextCustomFieldSearchInputTransformer
extends AbstractSingleValueCustomFieldSearchInputTransformer
implements SearchInputTransformer {
    private static final Logger log = Logger.getLogger(FreeTextCustomFieldSearchInputTransformer.class);
    private final CustomField customField;
    private final ClauseNames clauseNames;

    public FreeTextCustomFieldSearchInputTransformer(CustomField customField, ClauseNames clauseNames, String urlParameterName, CustomFieldInputHelper customFieldInputHelper) {
        super(customField, clauseNames, urlParameterName, customFieldInputHelper);
        this.customField = customField;
        this.clauseNames = clauseNames;
    }

    @Override
    Clause createSearchClause(User user, String value) {
        return new TerminalClauseImpl(this.getClauseName(user, this.clauseNames), Operator.LIKE, value);
    }

    @Override
    public boolean doRelevantClausesFitFilterForm(User user, Query query, SearchContext searchContext) {
        return this.convertForNavigator(query).fitsNavigator();
    }

    @Override
    public void validateParams(User user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, I18nHelper i18nHelper, ErrorCollection errors) {
        if (fieldValuesHolder.containsKey(this.customField.getId())) {
            CustomFieldParams customFieldParams = (CustomFieldParams)fieldValuesHolder.get(this.customField.getId());
            if (this.customField.getReleventConfig(searchContext) != null) {
                String paramValue = this.getFieldValueAsString(this.customField.getCustomFieldType(), customFieldParams, errors);
                if (paramValue != null) {
                    String firstLetter = String.valueOf(paramValue.charAt(0));
                    if (FreeTextFieldValidator.INVALID_FIRST_CHAR_LIST.contains(firstLetter)) {
                        errors.addError(this.customField.getId(), i18nHelper.getText("navigator.error.query.invalid.start", firstLetter));
                    } else if (!this.isQueryValid(paramValue, this.customField)) {
                        errors.addError(this.customField.getId(), i18nHelper.getText("navigator.error.parse"));
                    }
                }
            } else {
                log.warn((Object)("Searcher " + this.getCustomField().getId() + " (" + ClassUtils.getShortClassName(this.getClass()) + ") tried to search with context it does not exist for. The search context is " + searchContext));
            }
        }
    }

    private String getFieldValueAsString(CustomFieldType customFieldType, CustomFieldParams customFieldParams, ErrorCollection errors) {
        String paramValue = null;
        Object paramValueObject = new Object();
        try {
            paramValueObject = customFieldType.getValueFromCustomFieldParams(customFieldParams);
            paramValue = (String)paramValueObject;
        }
        catch (FieldValidationException e) {
            errors.addError(this.getCustomField().getId(), e.getMessage());
        }
        catch (ClassCastException e) {
            errors.addError(this.getCustomField().getId(), "Internal error attempting to validate the search term.");
            String mesg = "Expected to be able to get String value out of custom customField that has a text searcher, actual value type is " + paramValueObject.getClass();
            log.error((Object)mesg);
        }
        return paramValue;
    }

    private boolean isQueryValid(String query, CustomField customField) {
        QueryParser qp = this.createQueryParser(customField);
        try {
            qp.parse(query);
            return true;
        }
        catch (ParseException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Can't parse text query, user notified." + (Object)((Object)e)));
            }
            return false;
        }
    }

    QueryParser createQueryParser(CustomField customField) {
        IssueIndexManager issueIndexManager = ComponentAccessor.getComponent(IssueIndexManager.class);
        return new QueryParser(IssueIndexManager.LUCENE_VERSION, customField.getId(), issueIndexManager.getAnalyzerForSearching());
    }
}

