/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.task.context;

import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.task.context.CompositeSink;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.JohnsonEventSink;
import com.atlassian.jira.task.context.LoggingContextSink;
import com.atlassian.jira.task.context.PercentageContext;
import com.atlassian.jira.task.context.TaskProgressPercentageContextSink;
import com.atlassian.jira.task.context.UnboundContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.collect.Sized;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.johnson.event.Event;
import org.apache.log4j.Logger;

public class Contexts {
    private static final Context NULL = new Context(){
        private final Context.Task task = new Context.Task(){

            @Override
            public void complete() {
            }
        };

        @Override
        public void setName(String arg0) {
        }

        @Override
        public Context.Task start(Object input) {
            return this.task;
        }
    };

    public static Context nullContext() {
        return NULL;
    }

    public static Context percentageReporter(@NotNull Sized sized, @NotNull TaskProgressSink sink, @NotNull I18nHelper i18n, @NotNull Logger logger, @NotNull String msg) {
        return Contexts.createContext(sized, new CompositeSink(new TaskProgressPercentageContextSink(i18n, sink), new LoggingContextSink(logger, msg)));
    }

    public static Context percentageReporter(@NotNull Sized sized, @NotNull TaskProgressSink sink, @NotNull I18nHelper i18n, @NotNull Logger logger, @NotNull String msg, @NotNull Event event) {
        return Contexts.createContext(sized, new CompositeSink(new JohnsonEventSink(event), new TaskProgressPercentageContextSink(i18n, sink), new LoggingContextSink(logger, msg)));
    }

    public static Context percentageLogger(@NotNull Sized sized, @NotNull Logger logger, @NotNull String msg) {
        return Contexts.createContext(sized, new LoggingContextSink(logger, msg));
    }

    private static Context createContext(@NotNull Sized sized, @NotNull PercentageContext.Sink contextSink) {
        Assertions.notNull("sized", sized);
        int size = sized.size();
        if (size > 0) {
            return new PercentageContext(size, contextSink);
        }
        return new UnboundContext(contextSink);
    }

    private Contexts() {
        throw new AssertionError((Object)"cannot instantiate!");
    }
}

