/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.charts.Chart;
import com.atlassian.jira.issue.search.SearchRequest;

public interface ChartFactory {
    public static final int FRAGMENT_IMAGE_HEIGHT = 250;
    public static final int FRAGMENT_IMAGE_WIDTH = 380;
    public static final int PORTLET_IMAGE_HEIGHT = 300;
    public static final int PORTLET_IMAGE_WIDTH = 450;
    public static final int REPORT_IMAGE_HEIGHT = 500;
    public static final int REPORT_IMAGE_WIDTH = 800;

    public Chart generateCreatedVsResolvedChart(ChartContext var1, int var2, PeriodName var3, VersionLabel var4, boolean var5, boolean var6);

    public Chart generateDateRangeTimeChart(ChartContext var1, int var2, PeriodName var3, long var4, String var6, String var7);

    public Chart generatePieChart(ChartContext var1, String var2);

    public Chart generateAverageAgeChart(ChartContext var1, int var2, PeriodName var3);

    public Chart generateRecentlyCreated(ChartContext var1, int var2, PeriodName var3);

    public Chart generateTimeSinceChart(ChartContext var1, int var2, PeriodName var3, boolean var4, String var5);

    public static class ChartContext {
        private final User remoteUser;
        private final SearchRequest searchRequest;
        private final int width;
        private final int height;

        public ChartContext(User remoteUser, SearchRequest searchRequest, int width, int height) {
            this.height = height;
            this.remoteUser = remoteUser;
            this.searchRequest = searchRequest;
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public User getRemoteUser() {
            return this.remoteUser;
        }

        public SearchRequest getSearchRequest() {
            return this.searchRequest;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChartContext that = (ChartContext)o;
            if (this.height != that.height) {
                return false;
            }
            if (this.width != that.width) {
                return false;
            }
            if (this.remoteUser != null ? !this.remoteUser.equals((Object)that.remoteUser) : that.remoteUser != null) {
                return false;
            }
            return !(this.searchRequest != null ? !this.searchRequest.equals(that.searchRequest) : that.searchRequest != null);
        }

        public int hashCode() {
            int result = this.remoteUser != null ? this.remoteUser.hashCode() : 0;
            result = 31 * result + (this.searchRequest != null ? this.searchRequest.hashCode() : 0);
            result = 31 * result + this.width;
            result = 31 * result + this.height;
            return result;
        }
    }

    public static enum PeriodName {
        hourly,
        daily,
        weekly,
        monthly,
        quarterly,
        yearly;

    }

    public static enum VersionLabel {
        none,
        major,
        all;

    }
}

