/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.roles;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.roles.DefaultRoleActors;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.MultiMap;
import com.atlassian.jira.util.collect.MultiMaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public interface ProjectRoleManager {
    public Collection<ProjectRole> getProjectRoles();

    public Collection<ProjectRole> getProjectRoles(User var1, Project var2);

    public ProjectRole getProjectRole(Long var1);

    public ProjectRole getProjectRole(String var1);

    public ProjectRole createRole(ProjectRole var1);

    public boolean isRoleNameUnique(String var1);

    public void deleteRole(ProjectRole var1);

    public void updateRole(ProjectRole var1);

    public ProjectRoleActors getProjectRoleActors(ProjectRole var1, Project var2);

    public void updateProjectRoleActors(ProjectRoleActors var1);

    public DefaultRoleActors getDefaultRoleActors(ProjectRole var1);

    public void updateDefaultRoleActors(DefaultRoleActors var1);

    public void applyDefaultsRolesToProject(Project var1);

    public void removeAllRoleActorsByNameAndType(String var1, String var2);

    public void removeAllRoleActorsByProject(Project var1);

    public boolean isUserInProjectRole(User var1, ProjectRole var2, Project var3);

    public Collection<Long> getProjectIdsContainingRoleActorByNameAndType(String var1, String var2);

    public List<Long> roleActorOfTypeExistsForProjects(List<Long> var1, ProjectRole var2, String var3, String var4);

    public Map<Long, List<String>> getProjectIdsForUserInGroupsBecauseOfRole(List<Long> var1, ProjectRole var2, String var3, String var4);

    public ProjectIdToProjectRoleIdsMap createProjectIdToProjectRolesMap(User var1, Collection<Long> var2);

    public static class ProjectIdToProjectRoleIdsMap
    implements Iterable<Entry> {
        private final MultiMap<Long, Long, List<Long>> map = MultiMaps.create(new Supplier<List<Long>>(){

            @Override
            public List<Long> get() {
                return new ArrayList<Long>();
            }
        });

        public void add(Long projectId, Long projectRoleId) {
            if (projectId != null && projectRoleId != null) {
                this.map.putSingle(projectId, projectRoleId);
            }
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Iterator<Entry> iterator() {
            return CollectionUtil.transformIterator(this.map.entrySet().iterator(), new Function<Map.Entry<Long, List<Long>>, Entry>(){

                @Override
                public Entry get(Map.Entry<Long, List<Long>> entry) {
                    return new Entry(entry.getKey(), entry.getValue());
                }
            });
        }

        public static class Entry {
            private final Long projectId;
            private final List<Long> projectRoleIds;

            private Entry(Long projectId, List<Long> projectRoleIds) {
                this.projectId = projectId;
                this.projectRoleIds = Collections.unmodifiableList(new ArrayList<Long>(projectRoleIds));
            }

            public Long getProjectId() {
                return this.projectId;
            }

            public List<Long> getProjectRoleIds() {
                return this.projectRoleIds;
            }
        }
    }
}

