/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.config;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.context.persistence.FieldConfigContextPersister;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigSchemeImpl;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MultiMap;
import org.ofbiz.core.entity.GenericValue;

@PublicApi
public interface FieldConfigScheme {
    public String getName();

    public String getDescription();

    public Map<String, FieldConfig> getConfigs();

    public Long getId();

    public List<JiraContextNode> getContexts();

    public boolean isInContext(IssueContext var1);

    @Deprecated
    public List<GenericValue> getAssociatedProjectCategories();

    public List<ProjectCategory> getAssociatedProjectCategoryObjects();

    @Deprecated
    public List<GenericValue> getAssociatedProjects();

    public List<Project> getAssociatedProjectObjects();

    public Set<GenericValue> getAssociatedIssueTypes();

    public boolean isGlobal();

    public boolean isAllProjects();

    public boolean isAllIssueTypes();

    public boolean isEnabled();

    public boolean isBasicMode();

    public MultiMap getConfigsByConfig();

    public FieldConfig getOneAndOnlyConfig();

    public ConfigurableField getField();

    public static class Builder {
        private Long id;
        private String name;
        private String description;
        private String fieldId;
        private Map<String, FieldConfig> configs;
        private FieldConfigContextPersister configContextPersister;

        public Builder() {
        }

        public Builder(FieldConfigScheme scheme) {
            if (scheme != null) {
                this.id = scheme.getId();
                this.name = scheme.getName();
                this.description = scheme.getDescription();
                this.configs = scheme.getConfigs();
                if (scheme instanceof FieldConfigSchemeImpl) {
                    FieldConfigSchemeImpl fieldConfigSchemeImpl = (FieldConfigSchemeImpl)scheme;
                    this.configContextPersister = fieldConfigSchemeImpl.getFieldConfigContextPersister();
                    this.fieldId = fieldConfigSchemeImpl.getFieldId();
                } else {
                    ConfigurableField field = scheme.getField();
                    this.fieldId = field != null ? field.getId() : null;
                }
            }
        }

        public Builder setId(Long id) {
            this.id = id;
            return this;
        }

        public Builder setFieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setConfigs(Map<String, FieldConfig> configs) {
            this.configs = configs;
            return this;
        }

        public Builder setFieldConfigContextPersister(FieldConfigContextPersister configContextPersister) {
            this.configContextPersister = configContextPersister;
            return this;
        }

        public FieldConfigScheme toFieldConfigScheme() {
            return new FieldConfigSchemeImpl(this.id, this.fieldId, this.name, this.description, this.configs, this.configContextPersister);
        }
    }
}

