/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers.transformer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.customfields.searchers.transformer.AbstractCustomFieldSearchInputTransformer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.customfields.view.CustomFieldParamsImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.transformer.FieldFlagOperandRegistry;
import com.atlassian.jira.issue.search.searchers.transformer.NavigatorStructureChecker;
import com.atlassian.jira.issue.search.searchers.transformer.SearchContextVisibilityChecker;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.SimpleNavigatorCollectorVisitor;
import com.atlassian.jira.issue.search.searchers.util.DefaultIndexedInputHelper;
import com.atlassian.jira.issue.search.searchers.util.IndexedInputHelper;
import com.atlassian.jira.issue.search.searchers.util.VersionIndexedInputHelper;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class VersionCustomFieldSearchInputTransformer
extends AbstractCustomFieldSearchInputTransformer
implements SearchInputTransformer {
    private final String urlParameterName;
    private final ClauseNames clauseNames;
    private final IndexInfoResolver<Version> indexInfoResolver;
    private final JqlOperandResolver operandResolver;
    private final FieldFlagOperandRegistry fieldFlagOperandRegistry;
    private final NavigatorStructureChecker navigatorStructureChecker;
    private final SearchContextVisibilityChecker searchContextVisibilityChecker;
    private final NameResolver<Version> versionResolver;
    private volatile IndexedInputHelper indexedInputHelper;
    private volatile DefaultIndexedInputHelper<Version> defaultIndexedInputHelper;
    private final VersionManager versionManager;

    public VersionCustomFieldSearchInputTransformer(String urlParameterName, ClauseNames clauseNames, CustomField field, IndexInfoResolver<Version> indexInfoResolver, JqlOperandResolver operandResolver, FieldFlagOperandRegistry fieldFlagOperandRegistry, SearchContextVisibilityChecker searchContextVisibilityChecker, NameResolver<Version> versionResolver, CustomFieldInputHelper customFieldInputHelper, VersionManager versionManager) {
        super(field, urlParameterName, customFieldInputHelper);
        this.versionManager = versionManager;
        this.versionResolver = Assertions.notNull("versionResolver", versionResolver);
        this.searchContextVisibilityChecker = Assertions.notNull("searchContextVisibilityChecker", searchContextVisibilityChecker);
        this.urlParameterName = Assertions.notNull("urlParameterName", urlParameterName);
        this.clauseNames = Assertions.notNull("clauseNames", clauseNames);
        this.indexInfoResolver = Assertions.notNull("indexInfoResolver", indexInfoResolver);
        this.operandResolver = Assertions.notNull("operandRegistry", operandResolver);
        this.fieldFlagOperandRegistry = Assertions.notNull("fieldFlagOperandRegistry", fieldFlagOperandRegistry);
        this.navigatorStructureChecker = this.createNavigatorStructureChecker();
    }

    @Override
    public boolean doRelevantClausesFitFilterForm(User user, Query query, SearchContext searchContext) {
        boolean structureIsCorrect = this.navigatorStructureChecker.checkSearchRequest(query, searchContext);
        if (!structureIsCorrect) {
            return structureIsCorrect;
        }
        return !this.queryContainsArchivedVersions(user, query);
    }

    @Override
    protected CustomFieldParams getParamsFromSearchRequest(User user, Query query, SearchContext searchContext) {
        if (query == null) {
            return null;
        }
        Set<String> valuesAsStrings = this.getIndexedInputHelper().getAllNavigatorValuesForMatchingClauses(user, this.clauseNames, query, searchContext);
        return new CustomFieldParamsImpl(this.getCustomField(), valuesAsStrings);
    }

    @Override
    public Clause getSearchClause(User user, FieldValuesHolder fieldValuesHolder) {
        CustomFieldParams customFieldParams;
        if (fieldValuesHolder.containsKey(this.urlParameterName) && (customFieldParams = (CustomFieldParams)fieldValuesHolder.get(this.urlParameterName)) != null && !customFieldParams.isEmpty()) {
            return this.getClauseFromParams(user, customFieldParams, fieldValuesHolder);
        }
        return null;
    }

    @Override
    protected Clause getClauseFromParams(User user, CustomFieldParams params) {
        return null;
    }

    protected Clause getClauseFromParams(User user, CustomFieldParams params, FieldValuesHolder fieldValuesHolder) {
        Collection searchValues = params.getAllValues();
        searchValues.removeAll(CollectionBuilder.newBuilder("", "-1").asCollection());
        if (!searchValues.isEmpty()) {
            Set<String> versionIds = this.getStrings(searchValues);
            IndexedInputHelper indexInputHelper = this.isVersionsNotRelatedToProjects(versionIds, fieldValuesHolder) ? this.getDefaultIndexedInputHelper() : this.getIndexedInputHelper();
            return indexInputHelper.getClauseForNavigatorValues(this.getClauseName(user, this.clauseNames), versionIds);
        }
        return null;
    }

    boolean isVersionsNotRelatedToProjects(Set<String> versionIdsFromHolder, FieldValuesHolder fieldValuesHolder) {
        List projects = (List)fieldValuesHolder.get(SystemSearchConstants.forProject().getUrlParameter());
        if (projects == null || projects.isEmpty()) {
            return false;
        }
        if (projects.size() == 1 && projects.contains("-1")) {
            return false;
        }
        if (projects.size() > 1) {
            return true;
        }
        for (String versionIdString : versionIdsFromHolder) {
            Version version = this.getVersionFromNavigatorValue(versionIdString);
            if (version == null || projects.contains(version.getProjectObject().getId().toString())) continue;
            return true;
        }
        return false;
    }

    private Version getVersionFromNavigatorValue(String versionIdString) {
        try {
            Long versionId = new Long(versionIdString);
            return this.versionResolver.get(versionId);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Set<String> getStrings(Collection values) {
        if (values == null) {
            return null;
        }
        for (Object o : values) {
            if (o instanceof String) continue;
            throw new IllegalArgumentException("Why are we putting non-String values in the FieldValuesHolder for searcher '" + this.urlParameterName + "'???");
        }
        LinkedHashSet<String> strings = new LinkedHashSet<String>(values);
        return strings;
    }

    NavigatorStructureChecker createNavigatorStructureChecker() {
        return new NavigatorStructureChecker<Version>(this.clauseNames, true, this.fieldFlagOperandRegistry, this.operandResolver, this.indexInfoResolver, this.searchContextVisibilityChecker);
    }

    IndexedInputHelper getIndexedInputHelper() {
        if (this.indexedInputHelper == null) {
            this.indexedInputHelper = this.createIndexedInputHelper();
        }
        return this.indexedInputHelper;
    }

    private IndexedInputHelper createIndexedInputHelper() {
        return new VersionIndexedInputHelper(this.indexInfoResolver, this.operandResolver, this.fieldFlagOperandRegistry, this.searchContextVisibilityChecker, this.versionResolver);
    }

    DefaultIndexedInputHelper getDefaultIndexedInputHelper() {
        if (this.defaultIndexedInputHelper == null) {
            this.defaultIndexedInputHelper = new DefaultIndexedInputHelper<Version>(this.indexInfoResolver, this.operandResolver, this.fieldFlagOperandRegistry, this.searchContextVisibilityChecker);
        }
        return this.defaultIndexedInputHelper;
    }

    boolean queryContainsArchivedVersions(User user, Query query) {
        SimpleNavigatorCollectorVisitor collector = new SimpleNavigatorCollectorVisitor(this.clauseNames.getJqlFieldNames());
        if (query != null && query.getWhereClause() != null) {
            query.getWhereClause().accept(collector);
            if (collector.getClauses().size() == 1) {
                TerminalClause terminalClause = collector.getClauses().get(0);
                ArrayList<String> ids = new ArrayList<String>();
                Operand operand = terminalClause.getOperand();
                List<QueryLiteral> queryLiteralList = this.operandResolver.getValues(user, operand, terminalClause);
                for (QueryLiteral queryLiteral : queryLiteralList) {
                    if (queryLiteral.getStringValue() != null) {
                        ids.addAll(this.indexInfoResolver.getIndexedValues(queryLiteral.getStringValue()));
                        continue;
                    }
                    if (queryLiteral.getLongValue() == null) continue;
                    ids.addAll(this.indexInfoResolver.getIndexedValues(queryLiteral.getLongValue()));
                }
                for (String idStr : ids) {
                    Version version;
                    Long lid = this.parseLong(idStr);
                    if (lid == null || (version = this.versionManager.getVersion(lid)) == null || !version.isArchived()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private Long parseLong(String str) {
        try {
            return Long.valueOf(str);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }
}

