/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action;

import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeRedirectChecker {
    private final Logger log = LoggerFactory.getLogger(SafeRedirectChecker.class);
    private final VelocityRequestContextFactory velocityRequestContextFactory;

    public SafeRedirectChecker(VelocityRequestContextFactory velocityRequestContextFactory) {
        this.velocityRequestContextFactory = velocityRequestContextFactory;
    }

    public boolean canRedirectTo(String redirectUri) {
        if (redirectUri == null) {
            return true;
        }
        try {
            URI uri = new URI(redirectUri);
            return (uri.getScheme() == null || redirectUri.startsWith(this.getCanonicalBaseURL())) && !redirectUri.startsWith("//");
        }
        catch (URISyntaxException e) {
            this.log.debug("Failed to parse URI '{}', redirect will not be allowed", (Object)redirectUri);
            return false;
        }
    }

    protected String getCanonicalBaseURL() {
        return this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl();
    }
}

