/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.core.util.FileSize;
import com.atlassian.core.util.thumbnail.Thumbnail;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.issue.thumbnail.ThumbnailManager;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.util.JiraUrlCodec;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AttachmentRenderedJsonBean {
    @JsonProperty
    private String self;
    @JsonProperty
    private String id;
    @JsonProperty
    private String filename;
    @JsonProperty
    private UserJsonBean author;
    @JsonProperty
    private String created;
    @JsonProperty
    private String size;
    @JsonProperty
    private String mimeType;
    @JsonProperty
    private String content;
    @JsonProperty
    private String thumbnail;

    public String getSelf() {
        return this.self;
    }

    public String getId() {
        return this.id;
    }

    public String getFilename() {
        return this.filename;
    }

    public UserJsonBean getAuthor() {
        return this.author;
    }

    public String getCreated() {
        return this.created;
    }

    public String getSize() {
        return this.size;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getContent() {
        return this.content;
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    public static Collection<AttachmentRenderedJsonBean> shortBeans(Collection<Attachment> attachments, final JiraBaseUrls urls, final ThumbnailManager thumbnailManager, final DateTimeFormatterFactory dateTimeFormatterFactory) {
        return Collections2.transform(attachments, (Function)new Function<Attachment, AttachmentRenderedJsonBean>(){

            public AttachmentRenderedJsonBean apply(Attachment from) {
                return AttachmentRenderedJsonBean.shortBean(from, urls, thumbnailManager, dateTimeFormatterFactory);
            }
        });
    }

    public static AttachmentRenderedJsonBean shortBean(Attachment attachment, JiraBaseUrls urls, ThumbnailManager thumbnailManager, DateTimeFormatterFactory dateTimeFormatterFactory) {
        AttachmentRenderedJsonBean bean;
        if (attachment == null) {
            return null;
        }
        try {
            bean = new AttachmentRenderedJsonBean();
            bean.self = urls.restApi2BaseUrl() + "attachment/" + JiraUrlCodec.encode(attachment.getId().toString());
            bean.id = attachment.getId().toString();
            bean.filename = attachment.getFilename();
            bean.size = FileSize.format((Long)attachment.getFilesize());
            bean.mimeType = attachment.getMimetype();
            User author = UserUtils.getUserEvenWhenUnknown(attachment.getAuthor());
            bean.author = UserJsonBean.shortBean(author, urls);
            bean.content = attachment.getFilename();
            bean.created = attachment.getCreated() == null ? "" : dateTimeFormatterFactory.formatter().forLoggedInUser().format(attachment.getCreated());
            String encodedFilename = URLEncoder.encode(attachment.getFilename(), "UTF-8");
            bean.content = String.format("%s/secure/attachment/%s/%s", urls.baseUrl(), attachment.getId(), encodedFilename);
            Thumbnail thumbnail = thumbnailManager.getThumbnail(attachment.getIssueObject(), attachment);
            if (thumbnail != null) {
                bean.thumbnail = AttachmentRenderedJsonBean.getThumbnailURL(urls, thumbnail, attachment.getId());
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error encoding file name", e);
        }
        return bean;
    }

    private static String getThumbnailURL(JiraBaseUrls urls, Thumbnail thumbnail, Long id) throws UnsupportedEncodingException {
        String thumbnailURL;
        if (thumbnail != null) {
            String encodedThumbnailFilename = URLEncoder.encode(thumbnail.getFilename(), "UTF-8");
            thumbnailURL = String.format("%s/secure/thumbnail/%s/%s", urls.baseUrl(), id, encodedThumbnailFilename);
        } else {
            thumbnailURL = null;
        }
        return thumbnailURL;
    }
}

