/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics.util;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.issue.search.ReaderCache;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.parameters.lucene.sort.JiraLuceneFieldFinder;
import com.atlassian.jira.issue.statistics.util.HitCollectorUtil;
import com.atlassian.jira.util.RuntimeIOException;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;

@Internal
public abstract class AbstractOneDimensionalHitCollector
extends Collector {
    private final String fieldId;
    private Collection<String>[] docToTerms;
    private Collection<String>[] docToProject;
    private Collection<String>[] docToIssueType;
    private final FieldVisibilityManager fieldVisibilityManager;
    private long irrelevantCount = 0L;
    private long hitCount = 0L;
    private int docBase = 0;

    public AbstractOneDimensionalHitCollector(String fieldId, IndexReader indexReader, FieldVisibilityManager fieldVisibilityManager, ReaderCache readerCache) {
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.fieldId = new HitCollectorUtil().getFieldId(fieldId);
        this.docToTerms = AbstractOneDimensionalHitCollector.readCachedMultiValueField(indexReader, fieldId, readerCache);
        this.docToProject = AbstractOneDimensionalHitCollector.readCachedSingleValueField(indexReader, SystemSearchConstants.forProject().getIndexField(), readerCache);
        this.docToIssueType = AbstractOneDimensionalHitCollector.readCachedSingleValueField(indexReader, SystemSearchConstants.forIssueType().getIndexField(), readerCache);
    }

    public void setScorer(Scorer scorer) throws IOException {
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.docBase = docBase;
    }

    public boolean acceptsDocsOutOfOrder() {
        return true;
    }

    public void collect(int i) {
        ++this.hitCount;
        Collection<String> terms = this.docToTerms[i += this.docBase];
        if (terms == null) {
            String issueTypeId;
            Long projectId = new Long(AbstractOneDimensionalHitCollector.getSingleValue(this.docToProject[i]));
            if (this.fieldVisibilityManager.isFieldHidden(projectId, this.fieldId, issueTypeId = AbstractOneDimensionalHitCollector.getSingleValue(this.docToIssueType[i]))) {
                ++this.irrelevantCount;
                this.collectIrrelevant(i);
            } else {
                this.collectWithTerms(i, terms);
            }
        } else {
            this.collectWithTerms(i, terms);
        }
    }

    private static String getSingleValue(Collection<String> source) {
        return source instanceof List ? (String)((List)source).get(0) : source.iterator().next();
    }

    public long getIrrelevantCount() {
        return this.irrelevantCount;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    protected abstract void collectIrrelevant(int var1);

    protected abstract void collectWithTerms(int var1, Collection<String> var2);

    private static Collection<String>[] readCachedMultiValueField(final IndexReader indexReader, final String fieldId, ReaderCache readerCache) {
        return readerCache.get(indexReader, fieldId, new Supplier<Collection<String>[]>(){

            @Override
            public Collection<String>[] get() {
                try {
                    return JiraLuceneFieldFinder.getInstance().getMatches(indexReader, fieldId);
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
            }
        });
    }

    private static Collection<String>[] readCachedSingleValueField(final IndexReader indexReader, final String fieldId, ReaderCache readerCache) {
        return readerCache.get(indexReader, fieldId, new Supplier<Collection<String>[]>(){

            @Override
            public Collection<String>[] get() {
                try {
                    return JiraLuceneFieldFinder.getInstance().getUniqueMatches(indexReader, fieldId);
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
            }
        });
    }
}

