/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts.jfreechart.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class PieDatasetUtil {
    public static PieDataset createConsolidatedSortedPieDataset(PieDataset source, Comparable key, boolean sort, double minimumPercent, int minItems) {
        DefaultPieDataset result = new DefaultPieDataset();
        double total = DatasetUtilities.calculatePieDatasetTotal((PieDataset)source);
        if (sort) {
            source = PieDatasetUtil.createSortedPieDataset(source);
        }
        List keys = source.getKeys();
        ArrayList<Comparable> otherKeys = new ArrayList<Comparable>();
        Iterator iterator = keys.iterator();
        int minItemsLeft = minItems;
        while (iterator.hasNext()) {
            Comparable currentKey = (Comparable)iterator.next();
            Number dataValue = source.getValue(currentKey);
            if (dataValue == null) continue;
            double value = dataValue.doubleValue();
            if (minItemsLeft <= 0 && value / total < minimumPercent) {
                otherKeys.add(currentKey);
                continue;
            }
            if (minItemsLeft <= 0) continue;
            --minItemsLeft;
        }
        iterator = keys.iterator();
        double otherValue = 0.0;
        while (iterator.hasNext()) {
            Comparable currentKey = (Comparable)iterator.next();
            Number dataValue = source.getValue(currentKey);
            if (dataValue == null) continue;
            if (otherKeys.contains(currentKey)) {
                otherValue += dataValue.doubleValue();
                continue;
            }
            result.setValue(currentKey, dataValue);
        }
        if (otherValue > 0.0) {
            result.setValue(key, (Number)new Integer((int)otherValue));
        }
        return result;
    }

    public static PieDataset createSortedPieDataset(PieDataset source) {
        ArrayList<SortableItem> items = new ArrayList<SortableItem>(source.getItemCount());
        for (Comparable key : source.getKeys()) {
            Number dataValue = source.getValue(key);
            items.add(new SortableItem(key, dataValue));
        }
        Collections.sort(items);
        Collections.reverse(items);
        DefaultPieDataset sortedDataset = new DefaultPieDataset();
        for (SortableItem sortableItem : items) {
            sortedDataset.setValue(sortableItem.key, sortableItem.value);
        }
        return sortedDataset;
    }

    private static class SortableItem
    implements Comparable {
        private Comparable key;
        private Number value;

        public SortableItem(Comparable key, Number value) {
            this.key = key;
            this.value = value;
        }

        public int compareTo(Object o) {
            if (o == null) {
                return 1;
            }
            Number n = ((SortableItem)o).value;
            if (this.value.doubleValue() > n.doubleValue()) {
                return 1;
            }
            if (this.value.doubleValue() < n.doubleValue()) {
                return -1;
            }
            return 0;
        }
    }
}

