/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.task.context;

import com.atlassian.jira.util.dbc.Assertions;
import java.util.concurrent.atomic.AtomicInteger;

class PercentageProgressCounter {
    private final Calculator calculator;
    private final AtomicInteger done = new AtomicInteger();

    PercentageProgressCounter(int total) {
        this.calculator = new Calculator(total);
    }

    boolean increment() {
        return this.calculator.calculate(this.done.incrementAndGet());
    }

    int getPercentComplete() {
        return this.calculator.get();
    }

    private static class Calculator {
        private static final int HUNDRED = 100;
        private final int total;
        private final AtomicInteger current = new AtomicInteger();

        public Calculator(int total) {
            Assertions.not("total <= 0", total <= 0);
            this.total = total;
        }

        boolean calculate(int count) {
            int percentage = count * 100 / this.total;
            return percentage != this.current.getAndSet(percentage);
        }

        int get() {
            return this.current.get();
        }
    }
}

