/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics.util;

import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.ReaderCache;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.parameters.lucene.sort.JiraLuceneFieldFinder;
import com.atlassian.jira.issue.statistics.TwoDimensionalStatsMap;
import com.atlassian.jira.issue.statistics.util.HitCollectorUtil;
import com.atlassian.jira.util.RuntimeIOException;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;

public class TwoDimensionalTermHitCollector
extends Collector {
    private final TwoDimensionalStatsMap statsMap;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final ReaderCache readerCache;
    private final LuceneFieldSorter aggregateField;
    private final Collection[] docToXTerms;
    private final Collection[] docToYTerms;
    private final Collection[] docToValueTerms;
    private Collection<String>[] projectDocToTerms;
    private Collection<String>[] issueTypeDocToTerms;
    private final String xFieldName;
    private final String yFieldName;
    private int docBase = 0;

    public TwoDimensionalTermHitCollector(TwoDimensionalStatsMap statsMap, IndexReader indexReader, FieldVisibilityManager fieldVisibilityManager, ReaderCache readerCache) {
        this(statsMap, indexReader, fieldVisibilityManager, readerCache, null);
    }

    public TwoDimensionalTermHitCollector(TwoDimensionalStatsMap statsMap, IndexReader indexReader, FieldVisibilityManager fieldVisibilityManager, ReaderCache readerCache, LuceneFieldSorter aggregateField) {
        this.statsMap = statsMap;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.readerCache = readerCache;
        this.aggregateField = aggregateField;
        this.docToXTerms = this.getDocToXTerms(indexReader, statsMap);
        this.docToYTerms = this.getDocToYTerms(indexReader, statsMap);
        HitCollectorUtil hitCollectorUtil = new HitCollectorUtil();
        this.xFieldName = hitCollectorUtil.getFieldId(statsMap.getxAxisMapper().getDocumentConstant());
        this.yFieldName = hitCollectorUtil.getFieldId(statsMap.getyAxisMapper().getDocumentConstant());
        this.docToValueTerms = this.getDocToValueTerms(aggregateField, indexReader);
        this.projectDocToTerms = this.getDocToValueTerms(SystemSearchConstants.forProject().getIndexField(), indexReader);
        this.issueTypeDocToTerms = this.getDocToValueTerms(SystemSearchConstants.forIssueType().getIndexField(), indexReader);
    }

    public void collect(int i) {
        this.adjustForValues(this.docBase + i);
    }

    public void setScorer(Scorer scorer) throws IOException {
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.docBase = docBase;
    }

    public boolean acceptsDocsOutOfOrder() {
        return true;
    }

    private void adjustForValues(int docId) {
        Collection xValues = this.docToXTerms[docId];
        Collection yValues = this.docToYTerms[docId];
        int incrementValue = this.docToValueTerms == null ? 1 : this.getFieldValue(docId);
        boolean xFieldNotVisible = false;
        boolean yFieldNotVisible = false;
        Long projectId = new Long(this.projectDocToTerms[docId].iterator().next());
        String issueTypeId = this.issueTypeDocToTerms[docId].iterator().next();
        if (xValues == null && this.fieldVisibilityManager.isFieldHidden(projectId, this.xFieldName, issueTypeId)) {
            xFieldNotVisible = true;
        }
        if (yValues == null && this.fieldVisibilityManager.isFieldHidden(projectId, this.yFieldName, issueTypeId)) {
            yFieldNotVisible = true;
        }
        if (xFieldNotVisible || yFieldNotVisible) {
            this.statsMap.adjustMapForIrrelevantValues(xValues, xFieldNotVisible, yValues, yFieldNotVisible, incrementValue);
        } else {
            this.statsMap.adjustMapForValues(xValues, yValues, incrementValue);
        }
    }

    private int getFieldValue(int i) {
        Number value = this.getValue(this.docToValueTerms[i]);
        return value != null ? value.intValue() : 0;
    }

    private Number getValue(Collection values) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        if (values.size() > 1) {
            throw new IllegalArgumentException("More than one value stored for statistic \"" + values.toString() + "\".");
        }
        Object o = this.aggregateField.getValueFromLuceneField((String)values.iterator().next());
        if (o == null) {
            return 0;
        }
        if (o instanceof Number) {
            return (Number)o;
        }
        throw new IllegalArgumentException("Value stored for statistic was \"" + (o != null ? o.getClass().getName() : "null") + "\".  Expected \"java.lang.Number\"");
    }

    private Collection[] getDocToXTerms(IndexReader indexReader, TwoDimensionalStatsMap statsMap) {
        return this.getDocToValueTerms(statsMap.getxAxisMapper().getDocumentConstant(), indexReader);
    }

    private Collection[] getDocToYTerms(IndexReader indexReader, TwoDimensionalStatsMap statsMap) {
        return this.getDocToValueTerms(statsMap.getyAxisMapper().getDocumentConstant(), indexReader);
    }

    private Collection[] getDocToValueTerms(LuceneFieldSorter aggregateField, IndexReader indexReader) {
        if (aggregateField != null) {
            return this.getDocToValueTerms(aggregateField.getDocumentConstant(), indexReader);
        }
        return null;
    }

    private Collection<String>[] getDocToValueTerms(final String documentConstant, final IndexReader indexReader) {
        return this.readerCache.get(indexReader, documentConstant, new Supplier<Collection<String>[]>(){

            @Override
            public Collection<String>[] get() {
                try {
                    return JiraLuceneFieldFinder.getInstance().getMatches(indexReader, documentConstant);
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
            }
        });
    }
}

