/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.parameters.lucene.sort;

import com.atlassian.jira.issue.search.parameters.lucene.sort.MappedSortComparator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;

public class JiraLuceneFieldFinder {
    private static final JiraLuceneFieldFinder FIELD_FINDER = new JiraLuceneFieldFinder();

    public static JiraLuceneFieldFinder getInstance() {
        return FIELD_FINDER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getCustom(IndexReader reader, String field, MappedSortComparator mappedSortComparator) throws IOException {
        String internedField = field.intern();
        Object[] retArray = new Object[reader.maxDoc()];
        if (retArray.length > 0) {
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(internedField, ""));
            try {
                if (termEnum.term() == null) {
                    Object[] objectArray = retArray;
                    return objectArray;
                }
                Comparator comparator = mappedSortComparator.getComparator();
                do {
                    Term term;
                    if ((term = termEnum.term()).field() != internedField) {
                        break;
                    }
                    Object termval = mappedSortComparator.getComparable(term.text());
                    termDocs.seek(termEnum);
                    while (termDocs.next()) {
                        Object currentValue = retArray[termDocs.doc()];
                        if (currentValue != null && comparator.compare(termval, currentValue) >= 1) continue;
                        retArray[termDocs.doc()] = termval;
                    }
                } while (termEnum.next());
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
        }
        return retArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String>[] getMatches(IndexReader reader, String field) throws IOException {
        String internedField = field.intern();
        Collection[] docToTerms = new Collection[reader.maxDoc()];
        if (docToTerms.length > 0) {
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(internedField, ""));
            try {
                if (termEnum.term() == null) {
                    throw new RuntimeException("no terms in field " + field);
                }
                do {
                    Term term;
                    if ((term = termEnum.term()).field() != internedField) {
                        break;
                    }
                    String termval = term.text();
                    termDocs.seek(termEnum);
                    while (termDocs.next()) {
                        ArrayList<String> currentValue = docToTerms[termDocs.doc()];
                        if (currentValue == null) {
                            currentValue = new ArrayList<String>();
                        }
                        currentValue.add(termval);
                        docToTerms[termDocs.doc()] = currentValue;
                    }
                } while (termEnum.next());
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
        }
        return docToTerms;
    }
}

