/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.dbc.Assertions;

public class Predicates {
    public static <T> Predicate<T> truePredicate() {
        return TruePredicate.getInstance();
    }

    public static <T> Predicate<T> falsePredicate() {
        return FalsePredicate.getInstance();
    }

    public static <T> Predicate<T> equalTo(final @NotNull T check) {
        Assertions.notNull("check", check);
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T input) {
                return check.equals(input);
            }
        };
    }

    public static <T> Predicate<T> notNull() {
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T input) {
                return input != null;
            }
        };
    }

    public static <T> Predicate<T> isNull() {
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T input) {
                return input != null;
            }
        };
    }

    public static <T> Predicate<T> isInstanceOf(final Class<? extends T> clazz) {
        Assertions.notNull("clazz", clazz);
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T input) {
                return input == null || clazz.isAssignableFrom(input.getClass());
            }
        };
    }

    public static <T> Predicate<T> allOf(Predicate<? super T> left, Predicate<? super T> right) {
        return new And<T>(left, right);
    }

    public static <T> Predicate<T> anyOf(Predicate<? super T> left, Predicate<? super T> right) {
        return new Or<T>(left, right);
    }

    public static <T> Predicate<T> not(Predicate<? super T> predicate) {
        return new NotPredicate(Assertions.notNull("predicate", predicate));
    }

    private static final class NotPredicate<T>
    implements Predicate<T> {
        private final Predicate<? super T> delegate;

        private NotPredicate(Predicate<? super T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean evaluate(T input) {
            return !this.delegate.evaluate(input);
        }
    }

    public static final class FalsePredicate<T>
    implements Predicate<T> {
        private static final Predicate<?> instance = new FalsePredicate();

        private FalsePredicate() {
        }

        protected Object clone() throws CloneNotSupportedException {
            throw new CloneNotSupportedException();
        }

        @Override
        public boolean evaluate(Object input) {
            return false;
        }

        public static <T> Predicate<T> getInstance() {
            return instance;
        }
    }

    public static final class TruePredicate<T>
    implements Predicate<T> {
        private static final Predicate<?> instance = new TruePredicate();

        private TruePredicate() {
        }

        protected Object clone() throws CloneNotSupportedException {
            throw new CloneNotSupportedException();
        }

        @Override
        public boolean evaluate(Object input) {
            return true;
        }

        public static <T> Predicate<T> getInstance() {
            return instance;
        }
    }

    public static abstract class Composite<T>
    implements Predicate<T> {
        final Predicate<? super T> left;
        final Predicate<? super T> right;

        Composite(Predicate<? super T> left, Predicate<? super T> right) {
            this.left = Assertions.notNull("left", left);
            this.right = Assertions.notNull("right", right);
        }
    }

    public static class Or<T>
    extends Composite<T> {
        Or(Predicate<? super T> left, Predicate<? super T> right) {
            super(left, right);
        }

        @Override
        public boolean evaluate(T input) {
            return this.left.evaluate(input) || this.right.evaluate(input);
        }
    }

    public static class And<T>
    extends Composite<T> {
        And(Predicate<? super T> left, Predicate<? super T> right) {
            super(left, right);
        }

        @Override
        public boolean evaluate(T input) {
            return this.left.evaluate(input) && this.right.evaluate(input);
        }
    }
}

