/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment;

import com.atlassian.annotations.PublicApi;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;

@PublicApi
public class DefaultWebFragmentContext {
    public static Map<String, Object> get(@Nullable String location) {
        HttpServletRequest currentRequest = ExecutingHttpRequest.get();
        User currentUser = ComponentAccessor.getComponent(JiraAuthenticationContext.class).getLoggedInUser();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (currentRequest != null) {
            builder.put((Object)"request", (Object)currentRequest).put((Object)"helper", (Object)new JiraHelper(currentRequest));
        }
        if (currentUser != null) {
            builder.put((Object)"user", (Object)currentUser).put((Object)"username", (Object)currentUser.getName());
        }
        if (location != null) {
            builder.put((Object)"location", (Object)location);
        }
        return builder.build();
    }

    public static Map<String, Object> get() {
        return DefaultWebFragmentContext.get(null);
    }
}

