/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.external.beans.ExternalUser;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.util.RegexpUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

public class ImportUtils {
    private static final ThreadLocal<Boolean> subvert = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private static final ThreadLocal<Boolean> indexIssues = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.TRUE;
        }
    };
    private static final ThreadLocal<Boolean> enableNotifications = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.TRUE;
        }
    };

    public static void setSubvertSecurityScheme(boolean subvert) {
        ImportUtils.subvert.set(subvert);
    }

    public static boolean isSubvertSecurityScheme() {
        Boolean isSubverted = subvert.get();
        return isSubverted;
    }

    public static void setIndexIssues(boolean index) {
        indexIssues.set(index);
    }

    public static void setEnableNotifications(boolean enable) {
        enableNotifications.set(enable);
    }

    public static boolean isEnableNotifications() {
        Boolean isEnableNotifications = enableNotifications.get();
        return isEnableNotifications;
    }

    public static boolean isIndexIssues() {
        Boolean isIndexing = indexIssues.get();
        return isIndexing;
    }

    public static String stripHTMLStrings(String str) {
        String newString = RegexpUtils.replaceAll(str, "<a (?:target=\"_new\" )?href=['\"](?:mailto:)?(.*?)['\"](?: target=\"_new\")?>.*</a>", "$1");
        newString = RegexpUtils.replaceAll(newString, "&quot;", "\"");
        newString = RegexpUtils.replaceAll(newString, "&lt;", "<");
        newString = RegexpUtils.replaceAll(newString, "&gt;", ">");
        newString = RegexpUtils.replaceAll(newString, "&amp;", "&");
        newString = RegexpUtils.replaceAll(newString, "&nbsp;", " ");
        return newString;
    }

    static Set<ExternalUser> getNonExistentUsers(Set<ExternalUser> users) {
        HashSet<ExternalUser> unknownUsers = new HashSet<ExternalUser>();
        for (ExternalUser externalUser : users) {
            User user = UserUtils.getUser(externalUser.getName());
            if (user != null || (user = UserUtils.getUserByEmail(externalUser.getEmail())) != null) continue;
            unknownUsers.add(externalUser);
        }
        return unknownUsers;
    }

    static String getSQLTokens(String[] names) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < names.length; ++i) {
            sb.append(" ? ");
            if (i == names.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    static void close(PreparedStatement ps, ResultSet rs) {
        ImportUtils.closePS(ps);
        ImportUtils.closeRS(rs);
    }

    static void closePS(PreparedStatement ps) {
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    static void closeRS(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private ImportUtils() {
    }
}

