/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.keyboardshortcut;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.plugin.keyboardshortcut.KeyboardShortcut;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@PublicApi
public interface KeyboardShortcutManager {
    public void registerShortcut(String var1, KeyboardShortcut var2);

    public void unregisterShortcut(String var1);

    public List<KeyboardShortcut> getActiveShortcuts();

    public List<KeyboardShortcut> getAllShortcuts();

    public void requireShortcutsForContext(Context var1);

    public String includeShortcuts();

    public boolean isKeyboardShortcutsEnabled();

    public static enum Operation {
        click,
        goTo,
        followLink,
        moveToAndFocus,
        moveToAndClick,
        moveToNextItem,
        moveToPrevItem,
        execute,
        evaluate;

    }

    public static enum Context {
        global,
        issuenavigation,
        issueaction,
        greenhopper,
        admin;

        private static final Map<String, Context> stringToEnum;

        public static Context fromString(String contextName) {
            return stringToEnum.get(contextName);
        }

        static {
            stringToEnum = new HashMap<String, Context>();
            for (Context context : Context.values()) {
                stringToEnum.put(context.toString(), context);
            }
        }
    }
}

